﻿// Script01.js

// Localization Routine using ISO 639-3 codes 
// English(eng), Russian(rus), Spanish(spa), Turkish(tur), Korean(kor), etc
// Terms:
//  Loc0. Language
//  Loc1. Part
//  Loc2. All
//  Loc3. FWD
//  Loc4. Entries
//  Loc5. Titles
//  Loc6. Type
//  Loc7. Exact
//  Loc8. All
//  Loc9. Most
//  Loc10. Any
//  Loc11. Enter Search Terms...
//  Loc12. Search
//  Loc13. Matches Found text for search results msg
//  Loc14. Error: must select Parts & Type
//  Loc15. Unpaired quotes, please correct...
//  Loc16. No search terms entered, please re-try
	
	var Loc0, Loc1, Loc2, Loc3, Loc4, Loc5, Loc6, Loc7, Loc8, Loc9, Loc10, Loc11, Loc12, Loc13, Loc14, Loc15, Loc16, Loc17, Loc18, Loc19, Loc20, Loc21, Loc22, Loc23, Loc24, Loc25, Loc26;
	function localize(lang)
	{

		switch(lang)
		{
		case 1:
			Loc0 = "Russian";
			Loc1 = "Часть";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Заголовки";
			Loc6 = "Тип";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Введите свой запрос...";
			Loc12 = "Искать";
			Loc13 = " найдено совпадений";
			Loc14 = " Наобходимо выделить Часть и тип";
			Loc15 = " Не парные кавычки, пожалуйста исправьте...";
			Loc16 = " Нет поискового запроса, попрубуйте снова...";
			break;
		case 2:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " найдено совпадений";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
		case 3:
			Loc0 = "Russian";
			Loc1 = "Часть";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Заголовки";
			Loc6 = "Тип";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Введите свой запрос...";
			Loc12 = "Искать";
			Loc13 = " найдено совпадений";
			Loc14 = " Наобходимо выделить Часть и тип";
			Loc15 = " Не парные кавычки, пожалуйста исправьте...";
			Loc16 = " Нет поискового запроса, попрубуйте снова...";
			break;
		case 4:
			Loc0 = "French";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
		case 5:
			Loc0 = "Spanish";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
		case 6:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
		case 7:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
		case 8:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
		case 9:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
		case 10:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 11:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 12:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 13:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 14:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 15:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 16:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 17:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 18:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 19:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 20:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 21:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 21:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
			case 22:
			Loc0 = "English";
			Loc1 = "Part";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Enter Search Terms...";
			Loc12 = "Search";
			Loc13 = " Matches Found";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
		case 23:
			Loc0 = "한국의";
			Loc1 = "부분";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Titles";
			Loc6 = "Type";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "탐색텀을 넣으세요...";
			Loc12 = "Search";
			Loc13 = " 개 찾앗다";
			Loc14 = " Must select a Part and Type";
			Loc15 = " Unpaired quotes, please correct...";
			Loc16 = " No search terms entered, please re-try...";
			break;
		case 24:
			Loc0 = "Russian";
			Loc1 = "Часть";
			Loc2 = "All";
			Loc3 = "FWD";
			Loc4 = "Entries";
			Loc5 = "Заголовки";
			Loc6 = "Тип";
			Loc7 = "Exact";
			Loc8 = "All";
			Loc9 = "Most";
			Loc10 = "Any";
			Loc11 = "Введите свой запрос...";
			Loc12 = "Искать";
			Loc13 = " найдено совпадений";
			Loc14 = " Наобходимо выделить Часть и тип";
			Loc15 = " Не парные кавычки, пожалуйста исправьте...";
			Loc16 = " Нет поискового запроса, попрубуйте снова...";
			break;
		}
		//alert("localize entered " + lang + " Loc11=" + Loc11+ " Loc13=" + Loc13);
		return;
	}
	

// Clean, and load terms into the termArray for subsequent processing

	function cleanTerms(inputString)
	{
		//var cleanerTerms = inputString.replace(/[\|&;\$%@"*#.,:?!<>\(\)\+,]/g, "");
		var cleanerTerms = inputString.replace(/[\|&;\$%@*#.,:?!<>\(\)\+,]/g, ""); // NOTE: Don't remove '"'
		var evenCleanerTerms = cleanerTerms.replace(/ +(?= )/g,'');		// Remove consecutive spaces
		var CleanestTerms = evenCleanerTerms.toLowerCase();				// Change all terms to lower case
		terms = terms.toLowerCase();								    // Change input box terms to lower case
		terms = terms.replace(/^\s+|\s+$/g,'');							// Trim leading & trailing space on input box terms
		CleanestTerms = CleanestTerms.replace(/^\s+|\s+$/g,'');			// Trim leading & trailing space on terms for array
		
		// Logic for double quoted arguments
		var quotedTermsCnt = (CleanestTerms.match(/"/g)||[]).length		// Count the number of double quotes in the search arg
		if (quotedTermsCnt % 2 == 1) {alert(Loc15);}						// Error if quotes are unpaired
		
		//console.log('CleanestTerms Before Extraction=' + CleanestTerms + "...");
		//console.log('quotesEncountered=' + quotedTermsCnt + "...");
		var quotePosStart = 0;
		var quotePosEnd = 0;
		var quotedTermsArray = new Array();
		
		// Find quoted terms, extract for CleanestTerms and put in quotedTerms Array
		if (quotedTermsCnt != 0)
			{
			for (d = 0; d < quotedTermsCnt/2 ; d++)
				{
				quotePosStart = CleanestTerms.indexOf('"');								// Find starting quote
				quotePosEnd = quotePosStart + CleanestTerms.substring(quotePosStart+1).indexOf('"');	// Find ending quote

				//console.log('quotePosStart=' + quotePosStart + ' quotePosEnd=' + quotePosEnd + " CleanestTerms=" + CleanestTerms);
				quotedTermsArray[d] = CleanestTerms.substring(quotePosStart+1, (quotePosEnd)+1); // Put term in quotedarray
				quotedTermsArray[d] = quotedTermsArray[d].replace(/^\s+|\s+$/g,'');		// Trim leading & trailing space on quoted terms			
				//console.log('quotedTermsArray=' + quotedTermsArray + "...");
				CleanestTerms = CleanestTerms.substring(0, quotePosStart) + CleanestTerms.substring(quotePosEnd+2); // Remove quoted term
				//console.log('d=' + d + ' CleanestTerms After Extraction=' + CleanestTerms + "...");

				}
			}
		
		termArray = CleanestTerms.split(" ");		// Load into an array for further processing
				
		
		//console.log('TermArrayLengthBeforeConCat=' + termArray.length + 'TermArrayLength[0]BeforeConCat=' + termArray[0].length + ' TermArrayItselfBeforeConCat=' + termArray + "...");
		
		//if (termArray.length >1 && termArray[0].length == 0)
		//	{termArray = quotedTermsArray}									// If only quoted term(s), replace termArray
		//	else
		termArray = quotedTermsArray.concat(termArray);				// Merge if there are quoted and non-quoted terms
		termArray = $.grep(termArray,function(n){					// Remove any null or undefined items created by the '.split above
    		return(n);
			});

		//console.log('finalTermsArray=' + termArray + "...");
		//alert00 = "@@@@@@termArray.Length=" + termArray.length + "termArray=" + termArray + "...";
	    //alert(alert00);
				
		return termArray;
	}

	function href_id(this_)
	{
		id = $(this_).attr("href"); 
		//alert("id = "+id);
		id = id.replace(":", "_"); id = id.replace(".", "_"); id = "p_" + id; id = id.replace("#", ""); 
		return id;
	}
// SEARCH THE [appropriate] TEXT ARRAY FOR MATCHES

	// Determine Search Parameters
	function searchText(searchTerms)
	{
		
				
	sRange = 0;
	eRange = 196;
		
	// Set Paper Range for Search
	if (sPart == "ALL") {sRange = 0; eRange = 196;}
	if (sPart == "FWD") {sRange = 0; eRange = 0;}
	if (sPart == "I")   {sRange = 1; eRange = 31;}
	if (sPart == "II")  {sRange = 32; eRange = 56;}
	if (sPart == "III") {sRange = 57; eRange = 119;}
	if (sPart == "IV")  {sRange = 120; eRange = 196;}
	
	// Set Search Type for switch routine below	
	if (sType == "Exact") { searchType = 1}
	if (sType == "All")  { searchType = 2}	
	if (sType == "Most" && termArray.length > 3) { searchType = 3}   // Accept 'MOST' if there are 4 or more search terms. Otherwise, default to 'All'.
	if (sType == "Most" && termArray.length < 4) { searchType = 2} 
	if (sType == "Any")  { searchType = 4}	
		
	// Set Row Type for Search (Title or Paragraph)
	if ($('#checkbox-tTitlesOnly').is(':checked'))
		{
			sEntryType = "Titles";
		}
		else
		{
			sEntryType = "All";
		}
				
	//alert( "Search Selections, sEntryType=" + sEntryType);
	//console.log(alert00);
		
	resultCnt = 0;
	resultsArray = new Array();
	var resultsOut = "";

	// Determine Active Text
	activeWindow = Number(activeWindow);		// Normalize type
	switch(activeWindow)
		{
		case 1:
				switchLanguage(Col1Language,0);
				//alert("activeWindow=" + activeWindow + " Col1Language=" + Col1Language);
		break;
		case 2:
				switchLanguage(Col2Language,0);
				//alert("activeWindow=" + activeWindow + " Col2Language=" + Col2Language);
		break;
		case 3:
				switchLanguage(Col3Language,0);
				//alert("activeWindow=" + activeWindow + " Col3Language=" + Col3Language);
		break;
		}
//alert("activeText.length=" +	activeText.length);	
//alert("parse_row(activeText)=" +	parse_row(activeText[2]));	
	for (t = 1; t < activeText.length; t++)					// Begin Searching the Entire text
		{
			resultSrt = parse_row(activeText[t]);
			resultEntry = restOfEntry;
			resultEntry = cleanText(resultEntry); //2016-04-18
			termCnt = 0;  // Used when ALL or MOST Terms must match is selected
			
			
			//if (t == 200) {t = 16212}
			//alert("srt=" + resultSrt + "paper=" + paper + " sRange=" + sRange + " eRange=" + eRange + " sEntryType=" + sEntryType + " rType=" + rType);

			//console.log("srt=" + resultSrt + "paper=" + paper + " sRange=" + sRange + " eRange=" + eRange + " sEntryType=" + sEntryType + " rType=" + rType);
		
		if ((paper >= sRange && paper <= eRange) && (sEntryType == "All" || sEntryType == rType))
			{
				
				switch(searchType)
				{
					
				case 1: if (resultEntry.toLowerCase().indexOf(terms) != -1)		// EXACT MATCH REQUESTED
							{
								hiType = 'Exact';
								highlightedText = hiliter(terms,resultEntry,hiType);
								addRowToResults(resultSrt,highlightedText);
								//alert01 = "case 1 entered=" + srt + " resultHTML=" + highlightedText;
	    						//console.log(alert01);								
							}
							break;
							
				case 2: for (m = 0; m <= termArray.length-1; m++)					// ALL TERMS MUST BE PRESENT
							{
								
								//var RegExAll = new RegExp("(\\b)(" + termArray[m] + ")(\\b)", "i");	
								var RegExAll = new RegExp("(^\|[ \n\r\t.,'\"\+!;>(“?-])(" + termArray[m] + ")([ \n\r\t.,'\"\+!<)(”:;&?-]+\|$)", "i");								
								if (RegExAll.test(resultEntry))		// If found (true) add to termCnt

								{
									termCnt++;

								}
							}
							if (termCnt == termArray.length)					// ALL TERMS WERE PRESENT
								{
									for (n = 0; n <= termArray.length-1; n++)
									{
										hiType = 'Word';
										resultEntry = hiliter(termArray[n],resultEntry,hiType);	
									}															
								
								addRowToResults(resultSrt,resultEntry);
								}
							break;
				
				case 3: for (m = 0; m <= termArray.length-1; m++)	// Are 'MOST' TERMS PRESENT (one less than actual number entered)?
							{
								
								//if (resultEntry.toLowerCase().indexOf(termArray[m]) != -1)	
								var RegExMost = new RegExp("(^\|[ \n\r\t.,'\"\+!;>(“?-])(" + termArray[m] + ")([ \n\r\t.,'\"\+!<)(”:;&?-]+\|$)", "i");								
								if (RegExMost.test(resultEntry))		// If found (true) add to termCnt

								{
									termCnt++;
									
									//alert03 = "case 3 entered, term=" + termArray[m] + " srt=" + srt + " resultHTML=" + resultEntry;
	    							//console.log(alert03);
								}
							}
									if (termCnt >= termArray.length-1)					// MOST TERMS WERE PRESENT
								{
									for (n = 0; n <= termArray.length-1; n++)
									{
										hiType = 'Word';
										resultEntry = hiliter(termArray[n],resultEntry,hiType);	
									}															
								
								addRowToResults(resultSrt,resultEntry);								
								
								}

							break;
							
				case 4: for (m = 0; m <= termArray.length-1; m++)			// 'ANY' TERMS PRESENT (at least one term is present) 
				
							{
								//if (resultEntry.toLowerCase().indexOf(termArray[m]) != -1)
								var RegExAny = new RegExp("(^\|[ \n\r\t.,'\"\+!;>(“?-])(" + termArray[m] + ")([ \n\r\t.,'\"\+!<)(”:;&?-]+\|$)", "i");							
								if (RegExAny.test(resultEntry))		// If found (true) add to termCnt	
								{
									termCnt++;
									
									//alert04 = "case 2 entered, term=" + termArray[m] + " srt=" + srt + " resultHTML=" + resultEntry;
	    							//console.log(alert04);
								}
								
							}
							if (termCnt > 0)					// ANY TERM IS PRESENT
								{
									for (n = 0; n <= termArray.length-1; n++)
									{
										hiType = 'Word';
										resultEntry = hiliter(termArray[n],resultEntry,hiType);	
										//resultEntry = hiliter(termArray[n],resultEntry);	
									}	
																								
								addRowToResults(resultSrt,resultEntry);
																							
								}

							break;
							
			}
			

		}
	}   // End of searchText function
	
	// Prepare Results

		for (k = 1; k < resultsArray.length; k++)
		{
		resultsOut+= resultsArray[k];
		}
		
		var fResults = resultsArray.length-1;
		if (fResults < 0) {fResults = 0;}
		
		activeWindow = Number(activeWindow)
		switch(activeWindow)
				{					
				case 1:
					resultsLang = Col1languageName;
					resultsLangId = Col1Language;
				break;
				case 2:
					resultsLang = Col2languageName;
					resultsLangId = Col2Language;
				break;
				case 3:
					resultsLang = Col3languageName;
					resultsLangId = Col3Language;
				break;
				}

		
		//$('#resultsMsg').html("<b font-size=\"14\">&nbsp;&nbsp;" + fResults + " " + Loc13 + " in the " + resultsLang + " version</b>");
		resultsOut = "<span class=\"resultsMsg\">-&raquo;&raquo; "+ fResults +" "+ Loc13 +" в "+ resultsLang +" version</span><br/>" + resultsOut;
		
		
		document.getElementById("resultsDiv").innerHTML=resultsOut;
		//document.getElementById("sResultMetrics").innerHTML=(resultsArray.length + Loc13);
		window.scrollTo(0, 0);
		document.getElementById('results').scrollTop = 0;

		//$("#resultsMsg").text($("#resultsName").text(fResults + " " + Loc13););
		//alert00 = "terms=" + termArray.length + "t=" + t + " resultHTML=" + resultsOut + " resultsArray.length=" + resultsArray.length;
	    //console.log(alert00);
		
		// Show results results onClick
		var prevtarget = "0";
		var prevpaper = "";
		
		// Re-enable Right-click functionality upon dialog box close
		//$('.paragraph,.section,.title').on('mousedown','',function (e) {
		//	$(document)[0].oncontextmenu = function() {return true;} 
		//});
		
		$('.tClass,.sClass,.pClass').on('mousedown','',function (e) {
			if (e.which ==3)								// Right-click on result item
			{
				
				// Disable Right-click functionality in the results column
				//$(document)[0].oncontextmenu = function() {return false;}  
				//var resultSelected = $(this).text();
				//alert("Rightclick detected=" + resultSelected);
				//contextMenu(resultSelected);
				
			}
			else
			{
			clicked_Result = $(this).text();   // Get the entire result
			clicked_Result = clicked_Result.substr(0,clicked_Result.indexOf(' '));  // extract the srt @ the beginning
			//alert("clicked_Result=" + clicked_Result);
			
			start_at = get_Idx(clicked_Result);			// get Paper's starting idx in the text array
			
			// Set activeText to the target columns language

			activeWindow = Number(activeWindow);
			switch(activeWindow)			
			{
				case 1: {
						switchLanguage(Col1Language,0);
						$("select#Col1country_id").val(Col1Language); // Set Language selector appropriately
					
						} 
				break;
				case 2: {
						switchLanguage(Col2Language,0);
						$("select#Col2country_id").val(Col2Language); // Set Language selector appropriately
						}
				break;
				case 3: {
						switchLanguage(Col3Language,0);
						$("select#Col3country_id").val(Col3Language); // Set Language selector appropriately
						}
				break;
			}

			//alert("Col1Language=" + Col1Language + " Col2Language=" + Col2Language + " Col3Language=" + Col3Language);
			 
			unHilitedPaper = format_paper(PaperToLoad,start_at,activeWindow);
			//alert("unHilitedPaper=" + unHilitedPaper);
					
			//Hilite paper to be loaded
			if (searchType == 1){unHilitedPaper = hiliter(terms,unHilitedPaper,hiType);	} 
			
			else
			{
				for (n = 0; n <= termArray.length-1; n++)
				{
					unHilitedPaper = hiliter(termArray[n],unHilitedPaper,hiType);	
				}		
			}
					

			
			// Enter logic to test Results against target window.....	
		
			activeWindow = Number(activeWindow);
			
			
			id = href_id(this);
			scrollId1 = "#Col1" + id;//2016-04-18
			scrollId2 = "#Col2" + id;
			scrollId3 = "#Col3" + id;
			//alert("script01:Case1:result=" + id);							
			
			switch(activeWindow)
			{
				case 1: {	
							$('#Col1').html(unHilitedPaper);

								switchLanguage(Col2Language,0);					// Set the current col2 language appropriately //2016-04-18
								$("select#Col2country_id").val(Col2Language); 	// Set Language selector appropriately
								//alert("Переходим на Яз2 "+clicked_Result+" start_at="+start_at+" scrollId1="+scrollId1+" scrollId2="+scrollId2);
								Col2output = format_paper(PaperToLoad,start_at,2);
								$('#Col2').html(Col2output);

								switchLanguage(Col3Language,0);					// Set the current col3 language appropriately
								$("select#Col3country_id").val(Col3Language); 	// Set Language selector appropriately
								Col3output = format_paper(PaperToLoad,start_at,3);
								$('#Col3').html(Col3output);
								//alert("Script01 Переходим на Яз3 "+clicked_Result+" start_at="+start_at+" scrollId1="+scrollId1+" scrollId3="+scrollId3+" Col3Paper="+Col3Paper+" PaperToLoad="+PaperToLoad);

							
							}
				break;
			
				case 2: {	
							if (Col2Language == 0) {alert(" Select a Urantia Book version for Column 2 and retry.");} else {$('#Col2').html(unHilitedPaper);}

								switchLanguage(Col1Language,0);					// Set the current col2 language appropriately //2016-04-18
								$("select#Col1country_id").val(Col1Language); 	// Set Language selector appropriately
								//alert("Переходим на Яз1 "+clicked_Result+" start_at="+start_at+" scrollId1="+scrollId1+" scrollId2="+scrollId2);
								Col1output = format_paper(PaperToLoad,start_at,1);
								$('#Col1').html(Col1output);

								switchLanguage(Col3Language,0);					// Set the current col2 language appropriately
								$("select#Col3country_id").val(Col3Language); 	// Set Language selector appropriately
								//alert("Переходим на Яз3 "+clicked_Result+" start_at="+start_at+" scrollId1="+scrollId1+" scrollId3="+scrollId3);
								Col3output = format_paper(PaperToLoad,start_at,3);
								$('#Col3').html(Col3output);
							
							//alert("Case2:result=" + id);
				 } 
				break;
				
				case 3: {	
							if (Col3Language == 0) {alert(" Select a Urantia Book version for Column 3 and retry.");} else {$('#Col3').html(unHilitedPaper);}
							//$('#Col3').html(unHilitedPaper);
							//alert("Case3:result=" + id);

								switchLanguage(Col1Language,0);					// Set the current col2 language appropriately //2016-04-18
								$("select#Col1country_id").val(Col1Language); 	// Set Language selector appropriately
								//alert("Переходим на Яз1 "+clicked_Result+" start_at="+start_at+" scrollId1="+scrollId1+" scrollId2="+scrollId2);
								Col1output = format_paper(PaperToLoad,start_at,1);
								$('#Col1').html(Col1output);

								switchLanguage(Col2Language,0);					// Set the current col2 language appropriately //2016-04-18
								$("select#Col2country_id").val(Col2Language); 	// Set Language selector appropriately
								//alert("Переходим на Яз2 "+clicked_Result+" start_at="+start_at+" scrollId1="+scrollId1+" scrollId2="+scrollId2);
								Col2output = format_paper(PaperToLoad,start_at,2);
								$('#Col2').html(Col2output);


				 }
				break;
			}
			Col1Paper = PaperToLoad;						// Change Paper number in Col1
			Col2Paper = PaperToLoad;						// Change Paper number in Col2
			Col3Paper = PaperToLoad;
			//И делаем прокрутку по всем языкам сразу
			$('#Col1').scrollTo($(scrollId1),400);
			$('#Col2').scrollTo($(scrollId2),400);				
			$('#Col3').scrollTo($(scrollId3),400);				
			$('html, body').animate({scrollTop: 0 }, 'slow');
			
			}
	 
		});	

	return;
	}

	
	
// Function to get Starting Idx for Paper

	function get_Idx(Srt_num)
	{
	Srt_num = Srt_num.toString();	
	var colonThere = Srt_num.indexOf(":");	// See if it's a section or paragraph and eliminate
	if (colonThere != -1) {Srt_num = Srt_num.substring(0,colonThere)}
	PaperToLoad = Srt_num;

		if (Srt_num == "I")  {clicked_Page = "1"; Srt_num = 1;} 
		if (Srt_num == "II") {clicked_Page = "32"; Srt_num = 32;} 
		if (Srt_num == "III"){clicked_Page = "57"; Srt_num = 57;} 
		if (Srt_num == "IV") {clicked_Page = "120"; Srt_num = 120;} 
		if (Srt_num == "T")  {clicked_Page = "0"; Srt_num = 0;} 
				
		var paper_start_row = paper_start_idx[Srt_num];

		//alert03 = ("@923 sccript01 get_Idx : Srt_num =" + Srt_num + " paper_start_row=" + paper_start_row);
		
		return paper_start_row;
	}

	function cleanText(text_row)
	{
			//Здесь чистим текст от тегов, которые мешают поиску
			res_row = text_row; //2016-04-18
			res_row = res_row.replace("<i>", "");
			res_row = res_row.replace("</i>", "");
			res_row = res_row.replace("<b>", "");
			res_row = res_row.replace("</b>", "");
			return res_row;	
	}
// Function to Parse text row to get the Srt#; rowType, and the restOfEntry

	function parse_row(text_row)
		{		
			var pipe_loc = text_row.indexOf("|");			
		  	srt = text_row.substring(0,pipe_loc);
			restOfEntry = text_row.substring(pipe_loc+1);
			rType = "All";
			
			// Determine Paper
			colonLoc = srt.indexOf(":");					// Check for the presence of a colon
			if(colonLoc == -1){ paper = parseInt(srt);}
			 else {paper = parseInt(srt.substring(0,colonLoc))}
			 
			//alert01 = "srt=" + srt + " paper=" + paper;
			//console.log(alert01);
			
			rowType = "";
		  	if (srt.indexOf(".") > 0)	{rowType = "P"}									// It's a PARAGRAPH
			if (srt.indexOf(":") > 0 && srt.indexOf(".") == -1 )	{rowType = "S"}		// It's a SECTION
			if (srt.indexOf(":")  == -1)	{rowType = "T";}							// It's a TITLE
			if (srt.substring(0,1) == "T" ||srt.substring(0,1) == "I" )					// It's a PART
				{				
				rowType = "-"
				//alert07 = "rowType =" + rowType + " restOfEntry=" + restOfEntry;
		    	//console.log(alert07);
				}
			if (rowType == "T" || rowType == "S"){ rType = "Titles"}    // Set rType to title for row selection process											
			
			//alert05 = "rowType =" + rowType + " srt=" + srt;
		    //console.log(alert05);
			
			return srt;	
		}
	
// Add Selected Result to resultsArray

	function addRowToResults(selectedSrt, selectedText)
	{
		resultCnt++;
		
		var formattedResult = "";
		var cssClass = "pClass";
		if (rowType == "T") {cssClass = "tClass"; }
		if (rowType == "S") {cssClass = "sClass"; }
				
				
		formattedResult = "<p><a href=\"#" + selectedSrt + "\" class=\"" + cssClass + "\"><span class=\"sup\">" + selectedSrt + " </span>" + selectedText + "</a></p>";

		
		resultsArray[resultCnt] = formattedResult;
			
		
		return;
	}
	
	
	
// Get acttext array rows for the Paper and Format for presentation

      function format_paper(paper_number, index_start, targetCol)
	  {

		//alert("...paper_number =" + paper_number + " index_start=" + index_start + " targetCol=" + targetCol);
		//alert("@993 script01 in format_paper=" + paper_number + "index_start"+ index_start);
			
		// Set the 'ID' prefix	
		targetCol = Number(targetCol);
		switch(targetCol)
		{
			case 1: whichCol = "Col1"; break;	
			case 2: whichCol = "Col2"; break;	
			case 3: whichCol = "Col3"; break;
		}
				  
		var formatted_paper='';
	   	var i = index_start; var str = "";
		var current_paper = paper_number.toString();
		
		//alert("current_paper =" + current_paper + "...while of activeText, i=" + i + " paper_number=" + paper_number + " activeText[i]=" + activeText[i]);										
		while (i < 16217 && activeText[i].substring(0,current_paper.length) == current_paper)
            {
						
				parse_row(activeText[i]); str = srt;
				str = str.replace(":", "_"); str = str.replace(".", "_"); str = "p_" + str;
		  		if (rowType == "P")										// It's a PARAGRAPH
		  			{
			  			formatted_paper+= "<p>" + "<a href=\"#\" class=\"pItem\"  id=\"" + whichCol + str + "\"><span class=\"sup\">" + srt + " </span></a><span class=\"paragraph\">" + restOfEntry + "</span></p>";
						
						//console.log("pItem....." + formatted_paper);
		  			}
															
		  		if (rowType == "S")										// It's a SECTION
		  			{
			  			if (srt != "0:0")								// Ignore section 0:0 in Foreword
						{
						formatted_paper+= "<p>" + "<a href=\"#\" class=\"sItem\"  id=\"" + whichCol + str + "\">" + "<center><span class=\"section\">" + restOfEntry + "</span></center></p>";
						}
		  			}
				
				if (rowType == "T")										// It's a TITLE
					{
					pTitle = restOfEntry;
					formatted_paper+= "<p>" + "<a href=\"#\" class=\"tItem\"  id=\"" + whichCol + str + "\">" + "<center><span class=\"section\">" + restOfEntry + "</span></center></p>";

					}
				
				i++;
			};
		  		  
		  //console.log('i=' + i + 'formatted_paper=' + formatted_paper + ' title=' + pTitle);

		 switch(targetCol)			  // Load the Paper title
		{
			case 1: document.getElementById("Col1Title").innerHTML=pTitle; break;	
			case 2: document.getElementById("Col2Title").innerHTML=pTitle; break;	
			case 3: document.getElementById("Col3Title").innerHTML=pTitle; break;
			
		}
		  
		  
		  
		  return formatted_paper;
	  }
	  
// Text Hiliter Function

	function hiliter(word, textElement, hiliteType) {
		if (hiliteType != 'Exact' || defaultLangIdx != "1" || hiliteType == 'Exact')
		{var rgxp = new RegExp(word,'gi');}			// Highlight based on an 'Exact' search or Unicode (non-English)text			
		else
		{var rgxp = new RegExp('\\b(' + word + ')\\b','gi');	// Highlight based on word boundaries
		}
	
	if (currentLang == 23)			// Accommodate lower case results in the korcmtext.js version
	{
		
		textElement = textElement.replace(rgxp, '<span class="lolite">$&</span>'); // Lolite all matches
		hilites(textElement, "<span class=\"lolite\">" )  // Get locations of all Lolitied text
		LoLocs = hiLocs;
		boldIt = "";

		//console.log("Number of Lolite Terms Found=" + LoLocs.length + "...Locations=" + LoLocs);
								
		for (repl = 0; repl < LoLocs.length; repl++)  // Replace lolited text with a hilite if it is bolded "<b>"
		{
				hilites(textElement, "<b>" )
				sBold = hiLocs;
				hilites(textElement, "</b>" )
				eBold = hiLocs;
	
				//console.log("sBold.length=" + sBold.length + "\n" + "sBold=" + sBold + "\n" + "eBold=" + eBold);
																
					for (bolded = 0; bolded < sBold.length; bolded++)
					{

						
					     if (LoLocs[repl] > sBold[bolded] && LoLocs[repl] < eBold[bolded])
					     {
						 boldIt = "Y";
						 bolded = sBold.length;
						 //console.log(textElement.length + "..." + textElement + "\n...HIGHLIGHT...LoLocs[repl]..." + LoLocs[repl] + "..." + sBold[bolded] + "..." + eBold[bolded]);
					     }
					}				
				
				if (boldIt == "Y")
				
				{
					textElement = textElement.substring(0,LoLocs[repl])+ "<span class=\"hilite\">" + textElement.substring(LoLocs[repl]+21);
					boldIt = "";
					
					//console.log("HIGHLIGHTED..." + textElement);
				}

		}
		
	}
	else
	{
		    textElement = textElement.replace(rgxp, '<span class="hilite">$&</span>');
	}
	return textElement;
}

