/*!
 * Tipped - The jQuery Tooltip - v3.1.8
 * (c) 2010-2013 Nick Stakenburg
 *
 * http://projects.nickstakenburg.com/tipped
 *
 * License: http://projects.nickstakenburg.com/tipped/license
 */
;var Tipped = { version: '3.1.8' };

Tipped.Skins = {
  // base skin, don't modify! (create custom skins in a separate file)
  'base': {
    afterUpdate: false,
    ajax: {
      cache: true,
      type: 'get'
    },
    background: {
      color: '#f2f2f2',
      opacity: 1
    },
    border: {
      size: 1,
      color: '#000',
      opacity: 1
    },
    closeButtonSkin: 'default',
    containment: {
      selector: 'viewport'
    },
    fadeIn: 180,
    fadeOut: 220,
    showDelay: 75,
    hideDelay: 25,
    radius: {
      size: 5,
      position: 'background'
    },
    hideAfter: false,
    hideOn: {
      element: 'self',
      event: 'mouseleave'
    },
    hideOthers: false,
    hook: 'topleft',
    inline: false,
    offset: { x: 0, y: 0 },
    onHide: false,
    onShow: false,
    shadow: {
      blur: 2,
      color: '#000',
      offset: { x: 0, y: 0 },
      opacity: .12
    },
    showOn: 'mousemove',
    spinner: true,
    stem: {
      height: 9,
      width: 18,
      offset: { x: 9, y: 9 },
      spacing: 2
    },
    target: 'self'
  },
  
  // Every other skin inherits from this one
  'reset': {
    ajax: false,
    closeButton: false,
    hideOn: [{
      element: 'self',
      event: 'mouseleave'
    }, {
      element: 'tooltip',
      event: 'mouseleave'
    }],
    hook: 'topmiddle',
    stem: true
  },
  
  'dark': {
    background: { color: '#282828' },
    border: { color: '#9b9b9b', opacity: .4, size: 1 },
    shadow: { opacity: .02 },
    spinner: { color: '#fff' }
  },
  
  'light': {
    background: { color: '#fff' },
    border: { color: '#646464', opacity: .4, size: 1 },
    shadow: { opacity: .04 }
  },
  
  'gray': {
    background: {
      color: [
        { position: 0, color: '#8f8f8f'},
        { position: 1, color: '#808080' }
      ]
    },
    border: { color: '#131313', size: 1, opacity: .6 } 
  },
  
  'tiny': {
    background: { color: '#161616' },
    border: { color: '#969696', opacity: .35, size: 1 },
    fadeIn: 0,
    fadeOut: 0,
    radius: 4,
    stem: {
      width: 11,
      height: 6,
      offset: { x: 6, y: 6 }
    },
    shadow: false,
    spinner: { color: '#fff' }
  },

  'yellow': {
    background: '#ffffaa',
    border: { size: 1, color: '#6d5208', opacity: .4 }
  },
  
  'red': {
    background: {
      color: [
        { position: 0, color: '#e13c37'},
        { position: 1, color: '#e13c37' }
      ]
    },
    border: { size: 1, color: '#150201', opacity: .6 },
    spinner: { color: '#fff' }
  },
  
  'green': {
    background: {
      color: [
        { position: 0, color: '#4bb638'},
        { position: 1, color: '#4aab3a' }
      ]
    },
    border: { size: 1, color: '#122703', opacity: .6 },
    spinner: { color: '#fff' }
  },

  'blue': {
    background: {
      color: [
        { position: 0, color: '#4588c8'},
        { position: 1, color: '#3d7cb9' }
      ]
    },
    border: { color: '#020b17', opacity: .6 },
    spinner: { color: '#fff' }
  }
};


/* black and white are dark and light without radius */
(function($) {
  $.extend(Tipped.Skins, {
    black: $.extend(true, {}, Tipped.Skins.dark, { radius: 0 }),
    white: $.extend(true, {}, Tipped.Skins.light, { radius: 0 })
  });
})(jQuery);

Tipped.Skins.CloseButtons = {
  'base': {
    diameter: 17,
    border: 2,
    x: { diameter: 10, size: 2, opacity: 1 },
    states: {
      'default': {
        background: {
          color: [
            { position: 0, color: '#1a1a1a' },
            { position: 0.46, color: '#171717' },
            { position: 0.53, color: '#121212' },
            { position: 0.54, color: '#101010' },
            { position: 1, color: '#000' }
          ],
          opacity: 1
        },
        x: { color: '#fafafa', opacity: 1 },
        border: { color: '#fff', opacity: 1 }
      },
      'hover': {
        background: {
          color: '#333',
          opacity: 1
        },
        x: { color: '#e6e6e6', opacity: 1 },
        border: { color: '#fff', opacity: 1 }
      }
    },
    shadow: {
      blur: 1,
      color: '#000',
      offset: { x: 0, y: 0 },
      opacity: .5
    }
  },

  'reset': {},

  'default': {},

  'light': {
    diameter: 17,
    border: 2,
    x: { diameter: 10, size: 2, opacity: 1 },
    states: {
      'default': {
        background: {
          color: [
            { position: 0, color: '#797979' },
            { position: 0.48, color: '#717171' },
            { position: 0.52, color: '#666' },
            { position: 1, color: '#666' }
          ],
          opacity: 1
        },
        x: { color: '#fff', opacity: .95 },
        border: { color: '#676767', opacity: 1 }
      },
      'hover': {
        background: {
          color: [
            { position: 0, color: '#868686' },
            { position: 0.48, color: '#7f7f7f' },
            { position: 0.52, color: '#757575' },
            { position: 1, color: '#757575' }
          ],
          opacity: 1
        },
        x: { color: '#fff', opacity: 1 },
        border: { color: '#767676', opacity: 1 }
      }
    }
  }
};


eval(function(p,a,c,k,e,r){e=function(c){return(c<a?'':e(parseInt(c/a)))+((c=c%a)>35?String.fromCharCode(c+29):c.toString(36))};if(!''.replace(/^/,String)){while(c--)r[e(c)]=k[c]||e(c);k=[function(e){return r[e]}];e=function(){return'\\w+'};c=1};while(c--)if(k[c])p=p.replace(new RegExp('\\b'+e(c)+'\\b','g'),k[c]);return p}('(12(a){12 c(a,b){14 c=[a,b];1b c.17=a,c.18=b,c}12 f(a){1P.5w&&5w[5w.6B?"6B":"8h"](a)}12 j(a){11.1h=a}12 k(a){14 b={};28(14 c 5x a)b[c]=a[c]+"2x";1b b}12 l(a,b){1b 1d.8i(a*a+b*b)}12 m(a){1b 2G*a/1d.31}12 n(a){1b a*1d.31/2G}12 o(a){1b 1/1d.4B(a)}12 v(b){1g(b){11.1h=b,u.1A(b);14 c=11.2g();11.1a=a.1m({},c.1a),11.2y=1,11.1q={},11.1W=a(b).1Y("2q-1W"),u.32(11),11.2b=11.1a.1v.1F,11.6C=11.1a.1n&&11.2b,11.3b={x:0,y:0},11.3m={18:0,17:0},11.1R()}}12 x(b,c){11.1h=b,11.1h&&c&&(11.1a=a.1m({33:3,1B:{x:0,y:0},1E:"#4C",1M:.5,2N:1},22[2]||{}),11.2y=11.1a.2N,11.1q={},11.1W=a(b).1Y("2q-1W"),w.32(11),11.1R())}12 z(b){11.1h=b,11.1h&&(11.1a=a.1m({33:5,1B:{x:0,y:0},1E:"#4C",1M:.5,2N:1},22[1]||{}),11.2y=11.1a.2N,11.1W=a(b).1Y("2q-1W"),y.32(11),11.1R())}12 A(b,c){28(14 d 5x c)c[d]&&c[d].3E&&c[d].3E===5y?(b[d]=a.1m({},b[d])||{},A(b[d],c[d])):b[d]=c[d];1b b}12 C(b,c){1g(11.1h=b,11.1h){14 e=a(b).1Y("2q-1W");e&&B.1A(b),e=h(),a(b).1Y("2q-1W",e),11.1W=e;14 f;"8j"!=a.1r(c)||d.2l(c)?f=22[2]||{}:(f=c,c=1s),11.1a=B.6D(f);14 g=b.6E("5z");1g(!c){14 i=b.6E("1Y-2q");i?c=i:g&&(c=g)}g&&(a(b).1Y("5A",g),b.8k("5z","")),11.2H=c,11.2m=11.1a.2m||+B.1a.4D,11.1q={2I:{15:1,19:1},5B:[],3c:[],2r:{4E:!1,2n:!1,1N:!1,3d:!1,1R:!1,4F:!1,5C:!1,3F:!1},5D:""};14 j=11.1a.1D;11.1D="2O"==j?"2O":"4G"!=j&&j?d.2l(j)?j:j&&1y.6F(j)||11.1h:11.1h,11.6G(),B.32(11)}}14 b=6H.3G.8l,d={6I:12(c,d){14 e=c;1b 12(){14 c=[a.1w(e,11)].6J(b.5E(22));1b d.5F(11,c)}},2l:12(a){1b a&&1==a.8m},4H:12(a,c){14 d=b.5E(22,2);1b 8n(12(){1b a.5F(a,d)},c)},47:12(a){1b d.4H.5F(11,[a,1].6J(b.5E(22,1)))},5G:12(a){1b{x:a.5H,y:a.6K}},1h:{4I:12(a){14 b=0,d=0;8o b+=a.4J||0,d+=a.4K||0,a=a.4L;8p(a);1b c(d,b)},4M:12(b){14 e=a(b).1B(),f=d.1h.4I(b),g={18:a(1P).4J(),17:a(1P).4K()};1b e.17+=f.17-g.17,e.18+=f.18-g.18,c(e.17,e.18)},5I:12(){12 a(a){28(14 b=a;b&&b.4L;)b=b.4L;1b b}1b 12(b){14 c=a(b);1b!(!c||!c.3e)}}()}},e=12(a){12 b(b){14 c=5J(b+"([\\\\d.]+)").8q(a);1b c?5K(c[1]):!0}1b{3n:!(!1P.8r||-1!==a.3o("5L"))&&b("8s "),5L:a.3o("5L")>-1&&(!!1P.5M&&5M.6L&&5K(5M.6L())||7.55),5N:a.3o("6M/")>-1&&b("6M/"),4N:a.3o("4N")>-1&&-1===a.3o("8t")&&b("8u:"),6N:!!a.3f(/8v.*8w.*8x/),4O:a.3o("4O")>-1&&b("4O/")}}(8y.8z),g={34:{48:{5O:"1.4.4",5P:1P.48&&48.8A.8B}},6O:12(){12 b(b){28(14 c=b.3f(a),d=c&&c[1]&&c[1].2P(".")||[],e=0,f=0,g=d.1Z;g>f;f++)e+=2z(d[f]*1d.6P(10,6-2*f));1b c&&c[3]?e-1:e}14 a=/^(\\d+(\\.?\\d+){0,3})([A-6Q-8C-]+[A-6Q-8D-9]+)?/;1b 12(a){11.34[a].6R||(11.34[a].6R=!0,(!11.34[a].5P||b(11.34[a].5P)<b(11.34[a].5O)&&!11.34[a].6S)&&(11.34[a].6S=!0,f("1U 8E "+a+" >= "+11.34[a].5O)))}}()},h=12(){14 a=0,b="8F";1b 12(c){28(c=c||b,a++;1y.6F(c+a);)a++;1b c+a}}(),i=12(){14 b=[];1b{1u:12(c){28(14 d=1s,e=0;b.1Z>e;e++)b[e]&&b[e].49==c.49&&b[e].1r.6T()==c.1r.6T()&&a.6U(b[e].1Y||{})==a.6U(c.1Y||{})&&(d=b[e].4P);1b d},4Q:12(c,d){11.1A(c.49),b.2o(a.1m({},c,{4P:d}))},1A:12(a){28(14 c=0;b.1Z>c;c++)b[c]&&b[c].49==a&&3H b[c]},6V:12(){b=[]}}}();a.1m(1U,12(){1b{2J:{3g:12(){14 a=1y.25("3g");1b!(!a.3p||!a.3p("2d"))}(),3I:12(){6W{1b!!("8G"5x 1P||1P.6X&&1y 8H 6X)}6Y(a){1b!1}}(),4a:12(){14 b=["8I","8J","8K"],c=!1;1b a.1x(b,12(a,b){6W{1y.8L(b),c=!0}6Y(d){}}),c}()},3q:12(){(11.2J.3g||e.3n)&&(g.6O("48"),a(1y).6Z(12(){B.70()}))},4R:12(a,b,c){1b j.4R(a,b,c),11.1u(a)},1u:12(a){1b 3r j(a)},5Q:12(a){1b B.5Q(a)},1X:12(a){1b 11.1u(a).1X(),11},1K:12(a){1b 11.1u(a).1K(),11},35:12(a){1b 11.1u(a).35(),11},2Q:12(a){1b 11.1u(a).2Q(),11},1A:12(a){1b 11.1u(a).1A(),11},4S:12(){1b B.4S(),11},5R:12(a){1b B.5R(a),11},5S:12(a){1b B.5S(a),11},1N:12(b){1g(d.2l(b))1b B.5T(b);1g("5U"!=a.1r(b)){14 c=a(b),e=0;1b a.1x(c,12(a,b){B.5T(b)&&e++}),e}1b B.3J().1Z},5V:12(){1b B.5V(),11}}}()),a.1m(j,{4R:12(b,c){1g(b){14 e=22[2]||{},f=[];1b B.71(),d.2l(b)?f.2o(3r C(b,c,e)):a(b).1x(12(a,b){f.2o(3r C(b,c,e))}),f}}}),a.1m(j.3G,{4b:12(){1b B.2s.4T={x:0,y:0},B.1u(11.1h)},1X:12(){1b a.1x(11.4b(),12(a,b){b.1X()}),11},1K:12(){1b a.1x(11.4b(),12(a,b){b.1K()}),11},35:12(){1b a.1x(11.4b(),12(a,b){b.35()}),11},2Q:12(){1b a.1x(11.4b(),12(a,b){b.2Q()}),11},1A:12(){1b B.1A(11.1h),11}});14 p={4U:12(){14 b;1b b=e.6N?{15:1P.5W,19:1P.5X}:{19:a(1P).19(),15:a(1P).15()}}},q={3s:1d.1G(1d.4V(1P.3s?5K(1P.3s)||1:1,2)),3q:12(){12 a(a){14 b=a.3p("2d");b.8M(q.3s,q.3s)}1b 1P.4W&&!1U.2J.3g&&e.3n?12(b){4W.8N(b),a(b)}:12(b){a(b)}}(),3K:12(b,c){a(b).3h({15:c.15*11.3s,19:c.19*11.3s}).1p(k(c))},72:12(b){14 c=a.1m({18:0,17:0,15:0,19:0,1o:0},22[1]||{}),d=c,e=d.17,f=d.18,g=d.15,h=d.19,i=d.1o;1b i?(b.2h(),b.3t(e+i,f),b.29(e+g-i,f+i,i,n(-90),n(0),!1),b.29(e+g-i,f+h-i,i,n(0),n(90),!1),b.29(e+i,f+h-i,i,n(90),n(2G),!1),b.29(e+i,f+i,i,n(-2G),n(-90),!1),b.2i(),b.36(),3u 0):(b.73(e,f,g,h),3u 0)},74:12(b,c){28(14 d=a.1m({x:0,y:0,1E:"#4C"},22[2]||{}),e=0,f=c.1Z;f>e;e++)28(14 g=0,h=c[e].1Z;h>g;g++){14 i=2z(c[e].3v(g))*(1/9);b.2R=t.2S(d.1E,i),i&&b.73(d.x+g,d.y+e,1,1)}},4c:12(b,c){14 d;1g("2t"==a.1r(c))d=t.2S(c);1I 1g("2t"==a.1r(c.1E))d=t.2S(c.1E,"2A"==a.1r(c.1M)?c.1M:1);1I 1g(a.5Y(c.1E)){14 e=a.1m({3L:0,3M:0,3N:0,3O:0},22[2]||{});d=q.75.76(b.8O(e.3L,e.3M,e.3N,e.3O),c.1E,c.1M)}1b d}};q.75={76:12(b,c){28(14 d="2A"==a.1r(22[2])?22[2]:1,e=0,f=c.1Z;f>e;e++){14 g=c[e];("5U"==a.1r(g.1M)||"2A"!=a.1r(g.1M))&&(g.1M=1),b.8P(g.1e,t.2S(g.1E,g.1M*d))}1b b}};14 r={77:["3P","4d","3Q","3R","4e","4f","4g","4h","4i","4j","4k","3S"],4l:{78:/^(18|17|1S|1Q)(18|17|1S|1Q|2u|2T)$/,1L:/^(18|1S)/,37:/(2u|2T)/,79:/^(18|1S|17|1Q)/},7a:12(){14 a={18:"19",17:"15",1S:"19",1Q:"15"};1b 12(b){1b a[b]}}(),37:12(a){1b!!a.3w().3f(11.4l.37)},7b:12(a){1b!11.37(a)},2K:12(a){1b a.3w().3f(11.4l.1L)?"1L":"2c"},5Z:12(a){14 b=1s,c=a.3w().3f(11.4l.79);1b c&&c[1]&&(b=c[1]),b},2P:12(a){1b a.3w().3f(11.4l.78)}},s={60:12(a){14 b=a.1a.1n;1b{15:b.15,19:b.19}},4m:12(b,c){14 d=a.1m({3T:"1G"},22[2]||{}),e=b.1a.1n,f=e.15,g=e.19,h=11.4X(f,g,c);1b d.3T&&(h.15=1d[d.3T](h.15),h.19=1d[d.3T](h.19)),{15:h.15,19:h.19}},4X:12(a,b,c){14 d=m(1d.7c(.5*(b/a))),e=2G-d,f=1d.4B(n(e-90))*c,g=a+2*f,h=g*b/a;1b{15:g,19:h}},3U:12(a,b){14 c=11.4m(a,b),d=11.60(a),f=(r.37(a.2b),1d.1G(c.19+b));1b a.1a.1n.1B||0,a.1a.1o&&a.1a.1o.2v||0,{2B:{1c:{15:1d.1G(c.15),19:1d.1G(f)}},1j:{1c:c},1n:{1c:{15:d.15,19:d.19}}}},61:12(b,c,d){14 f=b.1a,g={18:0,17:0},h={18:0,17:0},i=a.1m({},c),j=b.1j,k=k||11.3U(b,b.1j),l=k.2B.1c;d&&(l.19=d,j=0);14 m=r.2P(b.2b),n=r.2K(b.2b);1g(b.1a.1n){14 o=r.5Z(b.2b);1g("18"==o?g.18=l.19-j:"17"==o&&(g.17=l.19-j),"1L"==n){1V(m[2]){1i"2u":1i"2T":h.17=.5*i.15;1C;1i"1Q":h.17=i.15}"1S"==m[1]&&(h.18=i.19-j+l.19)}1I{1V(m[2]){1i"2u":1i"2T":h.18=.5*i.19;1C;1i"1S":h.18=i.19}"1Q"==m[1]&&(h.17=i.15-j+l.19)}i[r.7a(o)]+=l.19-j}1I 1g("1L"==n){1V(m[2]){1i"2u":1i"2T":h.17=.5*i.15;1C;1i"1Q":h.17=i.15}"1S"==m[1]&&(h.18=i.19)}1I{1V(m[2]){1i"2u":1i"2T":h.18=.5*i.19;1C;1i"1S":h.18=i.19}"1Q"==m[1]&&(h.17=i.15)}14 p=f.1o&&f.1o.2v||0,q=f.1j&&f.1j.2v||0;1g(b.1a.1n){14 t=p&&"1k"==f.1o.1e?p:0,u=p&&"1j"==f.1o.1e?p:p+q,v=q+t+.5*k.1n.1c.15-.5*k.1j.1c.15,w=u>v?u-v:0,x=1d.1G(q+t+.5*k.1n.1c.15+w);1g("1L"==n)1V(m[2]){1i"17":h.17+=x;1C;1i"1Q":h.17-=x}1I 1V(m[2]){1i"18":h.18+=x;1C;1i"1S":h.18-=x}}14 y;1g(f.1n&&(y=f.1n.1B)){14 z=s.62(y,b.6C,c,k.1j.1c,q,p);1g(y=z.1B,z.4n,"1L"==n)1V(m[2]){1i"17":h.17+=y.x;1C;1i"1Q":h.17-=y.x}1I 1V(m[2]){1i"18":h.18+=y.y;1C;1i"1S":h.18-=y.y}}14 B;1g(f.1n&&(B=f.1n.8Q))1g("1L"==n)1V(m[1]){1i"18":h.18-=B;1C;1i"1S":h.18+=B}1I 1V(m[1]){1i"17":h.17-=B;1C;1i"1Q":h.17+=B}1b{1c:i,1e:{18:0,17:0},1k:{1e:g,1c:c},1n:{1c:l},2L:h}},62:12(b,c,d,e,f,g){14 h=r.2K(c),i=a.1m({},b),j={x:0,y:0},k=0;1b"1L"==h&&(k=d.15-e.15-2*f-2*g)<2*b.x&&(j.x=i.x,/(1Q)$/.3i(c)&&(j.x*=-1),i.x=0),"2c"==h&&(k=d.19-e.19-2*f-2*g)<2*b.y&&(j.y=i.y,/(1S)$/.3i(c)&&(j.y*=-1),i.y=0),{1B:i,4n:j}}},t=12(){12 d(a){14 b=a;1b b.7d=a[0],b.7e=a[1],b.7f=a[2],b}12 e(a){1b 2z(a,16)}12 f(a){14 b=6H(3);1g(0==a.3o("#")&&(a=a.4Y(1)),a=a.3w(),""!=a.63(c,""))1b 1s;3==a.1Z?(b[0]=a.3v(0)+a.3v(0),b[1]=a.3v(1)+a.3v(1),b[2]=a.3v(2)+a.3v(2)):(b[0]=a.4Y(0,2),b[1]=a.4Y(2,4),b[2]=a.4Y(4));28(14 f=0;b.1Z>f;f++)b[f]=e(b[f]);1b d(b)}12 g(a,b){14 c=f(a);1b c[3]=b,c.1M=b,c}12 h(b,c){1b"5U"==a.1r(c)&&(c=1),"8R("+g(b,c).8S()+")"}12 i(a){1b"#"+(j(a)[2]>50?"4C":"8T")}12 j(a){1b k(f(a))}12 k(a){14 f,g,h,a=d(a),b=a.7d,c=a.7e,e=a.7f,i=b>c?b:c;e>i&&(i=e);14 j=c>b?b:c;1g(j>e&&(j=e),h=i/8U,g=0!=i?(i-j)/i:0,0==g)f=0;1I{14 k=(i-b)/(i-j),l=(i-c)/(i-j),m=(i-e)/(i-j);f=b==i?m-l:c==i?2+k-m:4+l-k,f/=6,0>f&&(f+=1)}f=1d.26(7g*f),g=1d.26(64*g),h=1d.26(64*h);14 n=[];1b n[0]=f,n[1]=g,n[2]=h,n.8V=f,n.8W=g,n.8X=h,n}14 b="8Y",c=5J("["+b+"]","g");1b{8Z:f,2S:h,7h:i}}(),u={4Z:{},1u:12(b){1g(!b)1b 1s;14 c=1s,d=a(b).1Y("2q-1W");1b d&&(c=11.4Z[d]),c},32:12(a){11.4Z[a.1W]=a},1A:12(a){14 b=11.1u(a);b&&(3H 11.4Z[b.1W],b.1A())}};a.1m(v.3G,12(){12 b(){11.1q.1v={};14 b=11.2b;a.1x(r.77,a.1w(12(b,c){14 d,e=11.1q.1v[c]={};11.2b=c;14 f=11.2p();d=f,e.2L=d.2L;14 g=d.1J.1c,h={18:d.1J.1e.18,17:d.1J.1e.17};1g(e.1J={1c:g,1e:h},e.1F={1c:d.23.1c},11.1t){14 i=11.1t.2p(),j=i.23.1e,k=e.1J.1e;a.1m(!0,e,{2L:i.2L,1J:{1e:{18:k.18+j.18,17:k.17+j.17}},1F:{1c:i.1F.1c}})}},11)),11.2b=b}12 c(){11.38(),11.1a.1t&&(w.1A(11.1h),11.1a.1z&&11.1a.1z.1t&&y.1A(11.1h)),11.2U&&(11.2U.1A(),11.2U=1s),11.1l&&(a(11.1l).1A(),11.1l=1s)}12 d(){11.1J&&(11.1z&&(a(11.1z).1A(),11.1z=1s,11.65=1s,11.66=1s),a(11.1J).1A(),11.1n=1s,11.1k=1s,11.1J=1s,11.1q={})}12 f(){14 a=11.2g();11.2I=a.1q.2I;14 b=a.1a;11.1o=b.1o&&b.1o.2v||0,11.1j=b.1j&&b.1j.2v||0,11.2e=b.2e;14 c=1d.4V(11.2I.19,11.2I.15);11.1o>c/2&&(11.1o=1d.67(c/2)),"1j"==11.1a.1o.1e&&11.1o>11.1j&&(11.1j=11.1o),11.1q={1a:{1o:11.1o,1j:11.1j,2e:11.2e}}}12 g(){11.38(),1P.4W&&1P.4W.91(1y);14 b=11.2g(),c=11.1a;11.1J=a("<2j>").20("92")[0],a(b.51).21(11.1J),11.52(),11.7i(b),c.1z&&(11.7j(b),c.1z.1t&&(11.2V?(11.2V.1a=c.1z.1t,11.2V.1R()):11.2V=3r z(11.1h,a.1m({2N:11.2y},c.1z.1t)))),e.3n&&7>e.3n&&a(b.1l).68(11.2U=a("<93>").20("94").3h({95:0,4o:"96:\'\';"})),11.53(),c.1t&&(11.1t?(11.1t.1a=c.1t,11.1t.1R()):11.1t=3r x(11.1h,11,a.1m({2N:11.2y},c.1t))),11.7k()}12 h(){14 b=11.2g(),c=a(b.1l),d=a(b.1l).69(".7l").7m()[0];1g(d){a(d).1p({15:"6a",19:"6a"});14 e=2z(c.1p("18")),f=2z(c.1p("17")),g=2z(c.1p("15"));c.1p({17:"-7n",18:"-7n",15:"97",19:"6a"}),b.1H("1N")||a(b.1l).1X();14 h=B.54.6b(d);b.1a.3j&&"2A"==a.1r(b.1a.3j)&&h.15>b.1a.3j&&(a(d).1p({15:b.1a.3j+"2x"}),h=B.54.6b(d)),b.1H("1N")||a(b.1l).1K(),b.1q.2I=h,c.1p({17:f+"2x",18:e+"2x",15:g+"2x"}),11.1R()}}12 i(a,b,c){14 d=!1;11.4p(a)&&(d=!0),11.7o(b)&&(d=!0),c&&11.7p(c)&&(d=!0),d&&11.1R()}12 j(a){14 b=!1;1b(11.3m.17!=a.17||11.3m.18!=a.18)&&(b=!0,11.3m=a),b}12 l(a){14 b=!1;1b(11.3b.x!=a.x||11.3b.y!=a.y)&&(b=!0,11.3b=a),b}12 m(a){14 c=!1;1b 11.2b!=a&&(c=!0,11.2b=a),c}12 o(){1b B.1u(11.1h)[0]}12 p(){1b s.3U(11,11.1j)}12 u(){14 b=11.2g().1a.1z,c=b.3x+2*b.1j;a(11.65).1p({17:-1*c+"2x"}),a(11.66).1p({17:0})}12 v(){14 b=11.2g().1a.1z,c=b.3x+2*b.1j;a(11.65).1p({17:0}),a(11.66).1p({17:c+"2x"})}12 A(b){14 c=b.1a.1z,d={15:c.3x+2*c.1j,19:c.3x+2*c.1j};a(b.1l).21(a(11.1z=1y.25("2j")).20("7q").1p(k(d)).21(a(11.7r=1y.25("2j")).20("98").1p(k(d)))),11.6c(b,"6d"),11.6c(b,"6e"),1U.2J.3I||e.4O||a(11.1z).3V("4q",a.1w(11.7s,11)).3V("56",a.1w(11.7t,11))}12 C(b,c){14 d=b.1a.1z,e=d.3x,f=d.1j||0,g=d.x.3x,h=d.x.2v,j=(d.x.99,d.2r[c||"6d"]),l={15:e+2*f,19:e+2*f};g>=e&&(g=e-2);14 m;a(11.7r).21(a(11[c+"7u"]=1y.25("2j")).20("9a").1p(a.1m(k(l),{17:("6e"==c?l.15:0)+"2x"}))),a(1y.3e).21(a(m=1y.25("3g"))),q.3K(m,l),q.3q(m);14 o=m.3p("2d");o.2N=11.2y,a(11[c+"7u"]).21(m),o.9b(l.15/2,l.19/2),o.2R=q.4c(o,j.1k,{3L:0,3M:0-e/2,3N:0,3O:0+e/2}),o.2h(),o.29(0,0,e/2,0,2*1d.31,!0),o.2i(),o.36(),f&&(o.2R=q.4c(o,j.1j,{3L:0,3M:0-e/2-f,3N:0,3O:0+e/2+f}),o.2h(),o.29(0,0,e/2,1d.31,0,!1),o.1f((e+f)/2,0),o.29(0,0,e/2+f,0,1d.31,!0),o.29(0,0,e/2+f,1d.31,0,!0),o.1f(e/2,0),o.29(0,0,e/2,0,1d.31,!1),o.2i(),o.36());14 p=g/2,r=h/2;1g(r>p){14 s=r;r=p,p=s}o.2R=t.2S(j.x.1E||j.x,j.x.1M||1),o.57(n(45)),o.2h(),o.3t(0,0),o.1f(0,p);28(14 u=0;4>u;u++)o.1f(0,p),o.1f(r,p),o.1f(r,p-(p-r)),o.1f(p,r),o.1f(p,0),o.57(n(90));o.2i(),o.36()}12 D(b){14 l,m,o,p,q,c=a.1m({1n:!1,3y:1s,9c:1s,2h:!1,2i:!1,3z:1s,3A:1s,1o:0,1j:0,58:0,39:{x:0,y:0}},22[1]||{}),d=c.3z,e=c.3A,f=c.39,g=c.1j,h=c.1o,i=c.3y,j=d.1k.1e,k=d.1k.1c,t={x:1d.2W(11.3b.x),y:1d.2W(11.3b.y)},u={x:0,y:0},v={x:0,y:0};1g(e){l=e.1n.1c,m=e.2B.1e,o=e.2B.1c,p=o.15-l.15;14 w=c.58,x=g+h+.5*l.15-.5*e.1j.1c.15;q=1d.1G(w>x?w-x:0);14 y=s.62(f,i,k,e.1j.1c,g,h);f=y.1B,v=y.4n,u={x:1d.1T(k.15-2*1d.1T(q,f.x||0)-e.1j.1c.15-(2*h||0),0),y:1d.1T(k.19-2*1d.1T(q,f.y||0)-e.1j.1c.19-(2*h||0),0)},r.37(i)&&(u.x*=.5,u.y*=.5),t.x=1d.4V(t.x,u.x),t.y=1d.4V(t.y,u.y),r.37(i)&&(0>11.3b.x&&t.x>0&&(t.x*=-1),0>11.3b.y&&t.y>0&&(t.y*=-1)),11.3m&&11.3m.3B&&a.1x(11.3m.3B,12(b,c){a.1x("18 1Q 1S 17".2P(" "),12(a,b){c==b&&5J("("+b+")$").3i(i)&&(t[/^(17|1Q)$/.3i(b)?"x":"y"]=0)})})}14 z,A;1g(h?(z=j.17+g+h,A=j.18+g):(z=j.17+g,A=j.18+g),f&&f.x&&/^(3P|3S)$/.3i(i)&&(z+=f.x),c.2h&&b.2h(),b.3t(z,A),c.1n)1V(i){1i"3P":z=j.17+g,h&&(z+=h),z+=1d.1T(q,f.x||0),z+=t.x,b.1f(z,A),A-=l.19,z+=.5*l.15,b.1f(z,A),A+=l.19,z+=.5*l.15,b.1f(z,A);1C;1i"4d":1i"59":z=j.17+.5*k.15-.5*l.15,z+=t.x,b.1f(z,A),A-=l.19,z+=.5*l.15,b.1f(z,A),A+=l.19,z+=.5*l.15,b.1f(z,A),z=j.17+.5*k.15-.5*o.15,b.1f(z,A);1C;1i"3Q":z=j.17+k.15-g-l.15,h&&(z-=h),z-=1d.1T(q,f.x||0),z-=t.x,b.1f(z,A),A-=l.19,z+=.5*l.15,b.1f(z,A),A+=l.19,z+=.5*l.15,b.1f(z,A)}1g(h?h&&(b.29(j.17+k.15-g-h,j.18+g+h,h,n(-90),n(0),!1),z=j.17+k.15-g,A=j.18+g+h):(z=j.17+k.15-g,A=j.18+g,b.1f(z,A)),c.1n)1V(i){1i"3R":A=j.18+g,h&&(A+=h),A+=1d.1T(q,f.y||0),A+=t.y,b.1f(z,A),z+=l.19,A+=.5*l.15,b.1f(z,A),z-=l.19,A+=.5*l.15,b.1f(z,A);1C;1i"4e":1i"5a":A=j.18+.5*k.19-.5*l.15,A+=t.y,b.1f(z,A),z+=l.19,A+=.5*l.15,b.1f(z,A),z-=l.19,A+=.5*l.15,b.1f(z,A);1C;1i"4f":A=j.18+k.19-g,h&&(A-=h),A-=l.15,A-=1d.1T(q,f.y||0),A-=t.y,b.1f(z,A),z+=l.19,A+=.5*l.15,b.1f(z,A),z-=l.19,A+=.5*l.15,b.1f(z,A)}1g(h?h&&(b.29(j.17+k.15-g-h,j.18+k.19-g-h,h,n(0),n(90),!1),z=j.17+k.15-g-h,A=j.18+k.19-g):(z=j.17+k.15-g,A=j.18+k.19-g,b.1f(z,A)),c.1n)1V(i){1i"4g":z=j.17+k.15-g,h&&(z-=h),z-=1d.1T(q,f.x||0),z-=t.x,b.1f(z,A),z-=.5*l.15,A+=l.19,b.1f(z,A),z-=.5*l.15,A-=l.19,b.1f(z,A);1C;1i"4h":1i"5b":z=j.17+.5*k.15+.5*l.15,z+=t.x,b.1f(z,A),z-=.5*l.15,A+=l.19,b.1f(z,A),z-=.5*l.15,A-=l.19,b.1f(z,A);1C;1i"4i":z=j.17+g+l.15,h&&(z+=h),z+=1d.1T(q,f.x||0),z+=t.x,b.1f(z,A),z-=.5*l.15,A+=l.19,b.1f(z,A),z-=.5*l.15,A-=l.19,b.1f(z,A)}1g(h?h&&(b.29(j.17+g+h,j.18+k.19-g-h,h,n(90),n(2G),!1),z=j.17+g,A=j.18+k.19-g-h):(z=j.17+g,A=j.18+k.19-g,b.1f(z,A)),c.1n)1V(i){1i"4j":A=j.18+k.19-g,h&&(A-=h),A-=1d.1T(q,f.y||0),A-=t.y,b.1f(z,A),z-=l.19,A-=.5*l.15,b.1f(z,A),z+=l.19,A-=.5*l.15,b.1f(z,A);1C;1i"4k":1i"5c":A=j.18+.5*k.19+.5*l.15,A+=t.y,b.1f(z,A),z-=l.19,A-=.5*l.15,b.1f(z,A),z+=l.19,A-=.5*l.15,b.1f(z,A);1C;1i"3S":A=j.18+g+l.15,h&&(A+=h),A+=1d.1T(q,f.y||0),A+=t.y,b.1f(z,A),z-=l.19,A-=.5*l.15,b.1f(z,A),z+=l.19,A-=.5*l.15,b.1f(z,A)}1b h?h&&(b.29(j.17+g+h,j.18+g+h,h,n(-2G),n(-90),!1),z=j.17+g+h,A=j.18+g,z+=1,b.1f(z,A)):(z=j.17+g,A=j.18+g,b.1f(z,A)),c.2i&&b.2i(),{x:z,y:A,1n:t,5d:v,39:f}}12 E(b){14 o,p,q,r,s,t,c=a.1m({1n:!1,3y:1s,2h:!1,2i:!1,3z:1s,3A:1s,1o:0,1j:0,7v:0,39:{x:0,y:0},5e:1s},22[1]||{}),d=c.3z,e=c.3A,g=(c.7v,c.39),h=c.1j,i=c.1o&&c.1o.2v||0,j=c.7w,k=c.3y,l=d.1k.1e,m=d.1k.1c,u=c.5e&&c.5e.1n||{x:0,y:0};1g(e){o=e.1n.1c,p=e.2B.1e,q=e.2B.1c,r=e.1j.1c,s=q.15-o.15;14 v=h+j+.5*o.15-.5*r.15;t=1d.1G(i>v?i-v:0)}14 w=l.17+h+j,x=l.18+h;j&&(w+=1),a.1m({},{x:w,y:x}),c.2h&&b.2h();14 z=a.1m({},{x:w,y:x});1g(x-=h,b.1f(w,x),i?i&&(b.29(l.17+i,l.18+i,i,n(-90),n(-2G),!0),w=l.17,x=l.18+i):(w=l.17,x=l.18,b.1f(w,x)),c.1n)1V(k){1i"3S":x=l.18+h,j&&(x+=j),x-=.5*r.15,x+=.5*o.15,x+=1d.1T(t,g.y||0),x+=u.y,b.1f(w,x),w-=r.19,x+=.5*r.15,b.1f(w,x),w+=r.19,x+=.5*r.15,b.1f(w,x);1C;1i"4k":1i"5c":x=l.18+.5*m.19-.5*r.15,x+=u.y,b.1f(w,x),w-=r.19,x+=.5*r.15,b.1f(w,x),w+=r.19,x+=.5*r.15,b.1f(w,x);1C;1i"4j":x=l.18+m.19-h-r.15,j&&(x-=j),x+=.5*r.15,x-=.5*o.15,x-=1d.1T(t,g.y||0),x-=u.y,b.1f(w,x),w-=r.19,x+=.5*r.15,b.1f(w,x),w+=r.19,x+=.5*r.15,b.1f(w,x)}1g(i?i&&(b.29(l.17+i,l.18+m.19-i,i,n(-2G),n(-9d),!0),w=l.17+i,x=l.18+m.19):(w=l.17,x=l.18+m.19,b.1f(w,x)),c.1n)1V(k){1i"4i":w=l.17+h,j&&(w+=j),w-=.5*r.15,w+=.5*o.15,w+=1d.1T(t,g.x||0),w+=u.x,b.1f(w,x),x+=r.19,w+=.5*r.15,b.1f(w,x),x-=r.19,w+=.5*r.15,b.1f(w,x);1C;1i"4h":1i"5b":w=l.17+.5*m.15-.5*r.15,w+=u.x,b.1f(w,x),x+=r.19,w+=.5*r.15,b.1f(w,x),x-=r.19,w+=.5*r.15,b.1f(w,x),w=l.17+.5*m.15+r.15,b.1f(w,x);1C;1i"4g":w=l.17+m.15-h-r.15,j&&(w-=j),w+=.5*r.15,w-=.5*o.15,w-=1d.1T(t,g.x||0),w-=u.x,b.1f(w,x),x+=r.19,w+=.5*r.15,b.1f(w,x),x-=r.19,w+=.5*r.15,b.1f(w,x)}1g(i?i&&(b.29(l.17+m.15-i,l.18+m.19-i,i,n(90),n(0),!0),w=l.17+m.15,x=l.18+m.15+i):(w=l.17+m.15,x=l.18+m.19,b.1f(w,x)),c.1n)1V(k){1i"4f":x=l.18+m.19-h,x+=.5*r.15,x-=.5*o.15,j&&(x-=j),x-=1d.1T(t,g.y||0),x-=u.y,b.1f(w,x),w+=r.19,x-=.5*r.15,b.1f(w,x),w-=r.19,x-=.5*r.15,b.1f(w,x);1C;1i"4e":1i"5a":x=l.18+.5*m.19+.5*r.15,x+=u.y,b.1f(w,x),w+=r.19,x-=.5*r.15,b.1f(w,x),w-=r.19,x-=.5*r.15,b.1f(w,x);1C;1i"3R":x=l.18+h,j&&(x+=j),x+=r.15,x-=.5*r.15-.5*o.15,x+=1d.1T(t,g.y||0),x+=u.y,b.1f(w,x),w+=r.19,x-=.5*r.15,b.1f(w,x),w-=r.19,x-=.5*r.15,b.1f(w,x)}1g(i?i&&(b.29(l.17+m.15-i,l.18+i,i,n(0),n(-90),!0),w=l.17+m.15-i,x=l.18):(w=l.17+m.15,x=l.18,b.1f(w,x)),c.1n)1V(k){1i"3Q":w=l.17+m.15-h,w+=.5*r.15-.5*o.15,j&&(w-=j),w-=1d.1T(t,g.x||0),w-=u.x,b.1f(w,x),x-=r.19,w-=.5*r.15,b.1f(w,x),x+=r.19,w-=.5*r.15,b.1f(w,x);1C;1i"4d":1i"59":w=l.17+.5*m.15+.5*r.15,w+=u.x,b.1f(w,x),x-=r.19,w-=.5*r.15,b.1f(w,x),x+=r.19,w-=.5*r.15,b.1f(w,x),w=l.17+.5*m.15-r.15,b.1f(w,x),b.1f(w,x);1C;1i"3P":w=l.17+h+r.15,w-=.5*r.15,w+=.5*o.15,j&&(w+=j),w+=1d.1T(t,g.x||0),w+=u.x,b.1f(w,x),x-=r.19,w-=.5*r.15,b.1f(w,x),x+=r.19,w-=.5*r.15,b.1f(w,x)}b.1f(z.x,z.y-h),b.1f(z.x,z.y),c.2i&&b.2i()}12 F(b){14 c=11.2p(),d=11.1a.1n&&11.4r(),e=11.2b&&11.2b.3w(),f=11.1o,h=11.1j,i=11.2e,k=({15:2*h+2*i+11.2I.15,19:2*h+2*i+11.2I.19},b.1a.1n&&b.1a.1n.1B||{x:0,y:0}),l=0,m=0;f&&(l="1k"==11.1a.1o.1e?f:0,m="1j"==11.1a.1o.1e?f:l+h),a(1y.3e).21(11.2X=1y.25("3g")),q.3K(11.2X,c.1J.1c),q.3q(11.2X);14 n=11.2X.3p("2d");n.2N=11.2y,a(11.1J).21(11.2X),n.2R=q.4c(n,11.1a.1k,{3L:0,3M:c.1k.1e.18+h,3N:0,3O:c.1k.1e.18+c.1k.1c.19-h}),n.9e=0;14 o;o=11.6f(n,{2h:!0,2i:!0,1j:h,1o:l,58:m,3z:c,3A:d,1n:11.1a.1n,3y:e,39:k}),n.36();28(14 p=["9f","7x","9g","7x","9h"],r=0,s=p.1Z,u=0,v=p.1Z;v>u;u++)r=1d.1T(r,p[u].1Z);14 w={17:5,18:5},x=b.2Y.3W;1g(x&&(x=a(x),w.17=2z(x.1p("2e-17"))||0,w.18=2z(x.1p("2e-18"))||0),q.74(n,p,{x:c.1k.1e.17+c.1k.1c.15-h-(w.17||0)-r,y:c.1k.1e.18+c.1k.1c.19-h-(w.18||0)-s,1E:t.7h(a.5Y(11.1a.1k.1E)?11.1a.1k.1E[11.1a.1k.1E.1Z-1].1E:11.1a.1k.1E)}),h){14 y=q.4c(n,11.1a.1j,{3L:0,3M:c.1k.1e.18,3N:0,3O:c.1k.1e.18+c.1k.1c.19});n.2R=y,o=11.6f(n,{2h:!0,2i:!1,1j:h,1o:l,58:m,3z:c,3A:d,1n:11.1a.1n,3y:e,39:k}),11.7y(n,{2h:!1,2i:!0,1j:h,7w:l,1o:{2v:m,1e:11.1a.1o.1e},3z:c,3A:d,1n:11.1a.1n,3y:e,39:o.39,5e:o}),n.36()}11.3C=o}12 G(){14 i,a=11.2g(),b=11.2I,c=a.1a,d=11.1o,f=11.1j,g=11.2e,h={15:2*f+2*g+b.15,19:2*f+2*g+b.19};1g(11.1a.1n){14 j=11.4r();i=j.2B.1c}14 k=s.61(11,h),l=k.1c,m=k.1e,h=k.1k.1c,o=k.1k.1e;k.1n.1c;14 r,t,u,q={18:0,17:0},v={15:l.15,19:l.19};1g(c.1z){14 w=d;"1k"==c.1o.1e&&(w+=f);14 x=w-1d.9i(n(45))*w,y="1Q";11.2b.3w().3f(/^(3Q|3R)$/)&&(y="17");14 z=c.1z.3x+2*c.1z.1j,r={15:z,19:z};1g(q.17=o.17-z/2+("17"==y?x:h.15-x),q.18=o.18-z/2+x,"17"==y){1g(0>q.17){14 A=1d.2W(q.17);v.15+=A,m.17+=A,q.17=0}}1I{14 B=q.17+z-v.15;B>0&&(v.15+=B)}1g(0>q.18){14 C=1d.2W(q.18);v.19+=C,m.18+=C,q.18=0}1g(11.1a.1z.1t){14 D=11.1a.1z.1t,E=D.33,F=D.1B;1g(t={15:r.15+2*E,19:r.19+2*E},u={18:q.18-E+F.y,17:q.17-E+F.x},"17"==y){1g(0>u.17){14 A=1d.2W(u.17);v.15+=A,m.17+=A,q.17+=A,u.17=0}}1I{14 B=u.17+t.15-v.15;B>0&&(v.15+=B)}1g(0>u.18){14 C=1d.2W(u.18);v.19+=C,m.18+=C,q.18+=C,u.18=0}}}14 G=k.2L;G.18+=m.18,G.17+=m.17;14 H={17:1d.1G(m.17+o.17+11.1j+11.1a.2e),18:1d.1G(m.18+o.18+11.1j+11.1a.2e)},I={1F:{1c:{15:1d.1G(v.15),19:1d.1G(v.19)}},23:{1c:{15:1d.1G(v.15),19:1d.1G(v.19)}},1J:{1c:l,1e:{18:1d.26(m.18),17:1d.26(m.17)}},1k:{1c:{15:1d.1G(h.15),19:1d.1G(h.19)},1e:{18:1d.26(o.18),17:1d.26(o.17)}},2L:{18:1d.26(G.18),17:1d.26(G.17)},2H:{1e:H}};1b 11.1a.1z&&(I.1z={1c:{15:1d.1G(r.15),19:1d.1G(r.19)},1e:{18:1d.26(q.18),17:1d.26(q.17)}},11.1a.1z.1t&&(I.2V={1c:{15:1d.1G(t.15),19:1d.1G(t.19)},1e:{18:1d.26(u.18),17:1d.26(u.17)}})),I}12 H(){14 b=11.2p(),c=11.2g();a(c.1l).1p(k(b.1F.1c)),a(c.51).1p(k(b.23.1c)),11.2U&&11.2U.1p(k(b.1F.1c)),a(11.1J).1p(a.1m(k(b.1J.1c),k(b.1J.1e))),11.1z&&(a(11.1z).1p(k(b.1z.1e)),b.2V&&a(11.2V.1l).1p(k(b.2V.1e))),a(c.2Y).1p(k(b.2H.1e))}12 I(a){11.2y=a||0,11.1t&&(11.1t.2y=11.2y)}12 J(a){11.7z(a),11.1R()}1b{52:f,7k:b,1R:g,1A:c,38:d,2g:o,2Q:h,5f:i,7p:j,7o:l,4p:m,7j:A,6c:C,7i:F,6f:D,7y:E,7s:u,7t:v,4r:p,2p:G,53:H,7z:I,9j:J}}());14 w={3k:{},1u:12(b){1g(!b)1b 1s;14 c=1s,d=a(b).1Y("2q-1W");1b d&&(c=11.3k[d]),c},32:12(a){11.3k[a.1W]=a},1A:12(a){14 b=11.1u(a);b&&(3H 11.3k[b.1W],b.1A())},4s:12(a){1b 1d.31/2-1d.6P(a,1d.4B(a)*1d.31)}};w.4t={4m:12(a,b){14 c=u.1u(a.1h),d=c.4r().1j.1c,e=11.4X(d.15,d.19,b,{3T:!1});1b{15:e.15,19:e.19}},9k:12(a,b,c){14 d=.5*a,e=m(1d.9l(d/l(d,b))),f=2G-e-90,g=o(n(f))*c,h=2*(d+g),i=h/a*b;1b{15:h,19:i}},4X:12(a,b,c){14 d=m(1d.7c(.5*(b/a))),e=2G-d,f=1d.4B(n(e-90))*c,g=a+2*f,h=g*b/a;1b{15:g,19:h}},3U:12(b){14 c=u.1u(b.1h),d=b.1a.33,e=r.7b(c.2b),g=(r.2K(c.2b),w.4t.4m(b,d)),h={2B:{1c:{15:1d.1G(g.15),19:1d.1G(g.19)},1e:{18:0,17:0}}};1g(d){h.2Z=[];28(14 i=0;d>=i;i++){14 j=w.4t.4m(b,i,{3T:!1}),k={1e:{18:h.2B.1c.19-j.19,17:e?d-i:(h.2B.1c.15-j.15)/2},1c:j};h.2Z.2o(k)}}1I h.2Z=[a.1m({},h.2B)];1b h},57:12(a,b,c){s.57(a,b.3l(),c)}},a.1m(x.3G,12(){12 b(){1b B.1u(11.1h)[0]}12 c(){1b u.1u(11.1h)}12 d(){11.38()}12 e(){11.1l&&(a(11.1l).1A(),11.1n=1s,11.1k=1s,11.1J=1s,11.1l=1s,11.1q={})}12 f(){}12 g(){11.38(),11.52();14 b=11.2g(),c=11.3l();11.1l=a("<2j>").20("9m")[0],a(b.1l).68(11.1l),c.2U&&a(b.1l).68(c.2U),c.2p(),a(11.1l).1p({18:0,17:0}),11.7A(),11.53()}12 h(){1b 11.1a.1M/(11.1a.33+1)}12 i(){14 b=11.3l(),c=b.2p(),d=11.2g(),e=11.2p(),f=11.1a.33,g=w.4t.3U(11),h=b.2b,i=r.5Z(h),j={18:f,17:f};1g(d.1a.1n){14 l=g.2Z[g.2Z.1Z-1];"17"==i&&(j.17+=1d.1G(l.1c.19)),"18"==i&&(j.18+=1d.1G(l.1c.19))}14 m=b.1q.1a,n=m.1o,o=m.1j;"1k"==d.1a.1o.1e&&n&&(n+=o);14 p=e.1J.1c;a(11.1l).21(a(11.1J=1y.25("2j")).20("9n").1p(k(p))).1p(k(p)),a(1y.3e).21(a(11.2X=1y.25("3g"))),q.3K(11.2X,e.1J.1c),q.3q(11.2X);14 s=11.2X.3p("2d");s.2N=11.2y,a(11.1J).21(11.2X);28(14 u=f+1,v=0;f>=v;v++)s.2R=t.2S(11.1a.1E,w.4s(v*(1/u))*(11.1a.1M/u)),q.72(s,{15:c.1k.1c.15+2*v,19:c.1k.1c.19+2*v,18:j.18-v,17:j.17-v,1o:n+v});1g(b.1a.1n){14 x={x:j.17,y:j.18},y=g.2Z[0].1c,z=b.1a.1n,A=o;A+=.5*z.15;14 B=b.1a.1o&&"1k"==b.1a.1o.1e?b.1a.1o.2v||0:0;B&&(A+=B);14 C=o+B+.5*z.15-.5*y.15,D=1d.1G(n>C?n-C:0),E=b.3C&&b.3C.1n||{x:0,y:0},F=b.3C&&b.3C.5d||{x:0,y:0};1g(A+=1d.1T(D,b.1a.1n.1B&&b.1a.1n.1B[i&&/^(17|1Q)$/.3i(i)?"y":"x"]||0),"18"==i||"1S"==i){1V(h){1i"3P":1i"4i":x.x+=A+E.x-F.x;1C;1i"4d":1i"59":1i"4h":1i"5b":x.x+=.5*c.1k.1c.15+E.x;1C;1i"3Q":1i"4g":x.x+=c.1k.1c.15-(A-E.x+F.x)}"1S"==i&&(x.y+=c.1k.1c.19);28(14 v=0,G=g.2Z.1Z;G>v;v++){s.2R=t.2S(11.1a.1E,w.4s(v*(1/u))*(11.1a.1M/u));14 f=g.2Z[v];s.2h(),"18"==i?(s.3t(x.x,x.y-v),s.1f(x.x-.5*f.1c.15,x.y-v),s.1f(x.x,x.y-v-f.1c.19),s.1f(x.x+.5*f.1c.15,x.y-v)):(s.3t(x.x,x.y+v),s.1f(x.x-.5*f.1c.15,x.y+v),s.1f(x.x,x.y+v+f.1c.19),s.1f(x.x+.5*f.1c.15,x.y+v)),s.2i(),s.36()}}1I{1V(h){1i"3S":1i"3R":x.y+=A+E.y-F.y;1C;1i"4k":1i"5c":1i"4e":1i"5a":x.y+=.5*c.1k.1c.19+E.y;1C;1i"4j":1i"4f":x.y+=c.1k.1c.19-(A-E.y+F.y)}"1Q"==i&&(x.x+=c.1k.1c.15);28(14 v=0,G=g.2Z.1Z;G>v;v++){s.2R=t.2S(11.1a.1E,w.4s(v*(1/u))*(11.1a.1M/u));14 f=g.2Z[v];s.2h(),"17"==i?(s.3t(x.x-v,x.y),s.1f(x.x-v,x.y-.5*f.1c.15),s.1f(x.x-v-f.1c.19,x.y),s.1f(x.x-v,x.y+.5*f.1c.15)):(s.3t(x.x+v,x.y),s.1f(x.x+v,x.y-.5*f.1c.15),s.1f(x.x+v+f.1c.19,x.y),s.1f(x.x+v,x.y+.5*f.1c.15)),s.2i(),s.36()}}}}12 j(){14 b=11.3l();b.2I,b.1o;14 e=b.2p(),g=(11.2g(),11.1a.33),h=a.1m({},e.1k.1c);h.15+=2*g,h.19+=2*g;14 i,k;1g(b.1a.1n){14 l=w.4t.3U(11);i=l.2B.1c,k=i.19}14 m=s.61(b,h,k),n=m.1c,o=m.1e,h=m.1k.1c,p=m.1k.1e,r=e.1J.1e,t=e.1k.1e,u={18:r.18+t.18-(p.18+g)+11.1a.1B.y,17:r.17+t.17-(p.17+g)+11.1a.1B.x},v=e.2L,x=e.23.1c,y={18:0,17:0};1g(0>u.18){14 z=1d.2W(u.18);y.18+=z,u.18=0,v.18+=z}1g(0>u.17){14 A=1d.2W(u.17);y.17+=A,u.17=0,v.17+=A}14 B={19:1d.1T(n.19+u.18,x.19+y.18),15:1d.1T(n.15+u.17,x.15+y.17)},C={17:1d.1G(y.17+e.1J.1e.17+e.1k.1e.17+b.1j+b.2e),18:1d.1G(y.18+e.1J.1e.18+e.1k.1e.18+b.1j+b.2e)},D={1F:{1c:B},23:{1c:x,1e:y},1l:{1c:n,1e:u},1J:{1c:n,1e:{18:1d.26(o.18),17:1d.26(o.17)}},1k:{1c:{15:1d.1G(h.15),19:1d.1G(h.19)},1e:{18:1d.26(p.18),17:1d.26(p.17)}},2L:v,2H:{1e:C}};1b D}12 l(){14 b=11.2p(),c=11.3l(),d=11.2g();1g(a(d.1l).1p(k(b.1F.1c)),a(d.51).1p(a.1m(k(b.23.1e),k(b.23.1c))),c.2U&&c.2U.1p(k(b.1F.1c)),d.1a.1z){14 e=c.2p(),f=b.23.1e,g=e.1z.1e;1g(a(c.1z).1p(k({18:f.18+g.18,17:f.17+g.17})),d.1a.1z.1t){14 h=e.2V.1e;a(c.2V.1l).1p(k({18:f.18+h.18,17:f.17+h.17}))}}a(11.1l).1p(a.1m(k(b.1l.1c),k(b.1l.1e))),a(11.1J).1p(k(b.1J.1c)),a(d.2Y).1p(k(b.2H.1e))}1b{52:f,1A:d,38:e,1R:g,2g:b,3l:c,2p:j,7B:h,7A:i,53:l}}());14 y={3k:{},1u:12(b){1g(!b)1b 1s;14 c=a(b).1Y("2q-1W");1b c?11.3k[c]:1s},32:12(a){11.3k[a.1W]=a},1A:12(a){14 b=11.1u(a);b&&(3H 11.3k[b.1W],b.1A())}};a.1m(z.3G,12(){12 b(){1b B.1u(11.1h)[0]}12 c(){1b u.1u(11.1h)}12 d(){1b 11.1a.1M/(11.1a.33+1)}12 e(){11.38()}12 f(){11.1l&&(a(11.1l).1A(),11.1l=1s)}12 g(){11.38();14 c=(11.2g(),11.3l()),d=c.2p().1z.1c,e=a.1m({},d),f=11.1a.33;e.15+=2*f,e.19+=2*f,a(c.1z).6g(a(11.1l=1y.25("2j")).20("9o")),a(1y.3e).21(a(11.4u=1y.25("3g"))),q.3K(11.4u,e),q.3q(11.4u);14 g=11.4u.3p("2d");g.2N=11.2y,a(11.1l).21(11.4u);28(14 h=e.15/2,i=e.19/2,j=d.19/2,k=f+1,l=0;f>=l;l++)g.2R=t.2S(11.1a.1E,w.4s(l*(1/k))*(11.1a.1M/k)),g.2h(),g.29(h,i,j+l,n(0),n(7g),!0),g.2i(),g.36()}1b{1R:g,1A:e,38:f,2g:b,3l:c,7B:d}}());14 B={2C:{},1a:{3X:"6h",4D:9p},70:12(){12 b(){14 b=["2D"];1U.2J.3I&&(b.2o("9q"),a(1y.3e).3V("2D",12(){1b 3u 0})),a.1x(b,12(b,c){a(1y.7C).9r(".3D .7q, .3D .9s-1F",c,12(b){b.9t(),b.9u(),B.6i(a(b.1D).5g(".3D")[0]).1K()})}),a(1P).3V("3K",a.1w(11.7D,11))}1b b}(),7D:12(){11.5h&&(1P.6j(11.5h),11.5h=1s),11.5h=d.4H(a.1w(12(){14 b=11.3J();a.1x(b,12(a,b){b.1e()})},11),9v)},5i:12(b){14 d,c=a(b).1Y("2q-1W");1g(!c){14 e=11.6i(a(b).5g(".3D")[0]);e&&e.1h&&(c=a(e.1h).1Y("2q-1W"))}1b c&&(d=11.2C[c])?d:3u 0},5Q:12(a){14 b;1b d.2l(a)&&(b=11.5i(a)),b&&b.1h},1u:12(b){14 c=[];1g(d.2l(b)){14 e=11.5i(b);e&&(c=[e])}1I a.1x(11.2C,12(d,e){e.1h&&a(e.1h).7E(b)&&c.2o(e)});1b c},6i:12(b){1g(!b)1b 1s;14 c=1s;1b a.1x(11.2C,12(a,d){d.1H("1R")&&d.1l===b&&(c=d)}),c},9w:12(b){14 c=[];1b a.1x(11.2C,12(d,e){e.1h&&a(e.1h).7E(b)&&c.2o(e)}),c},1X:12(b){1g(d.2l(b)){14 c=b,e=11.1u(c)[0];e&&e.1X()}1I a(b).1x(a.1w(12(a,b){14 c=11.1u(b)[0];c&&c.1X()},11))},1K:12(b){1g(d.2l(b)){14 c=11.1u(b)[0];c&&c.1K()}1I a(b).1x(a.1w(12(a,b){14 c=11.1u(b)[0];c&&c.1K()},11))},35:12(b){1g(d.2l(b)){14 c=b,e=11.1u(c)[0];e&&e.35()}1I a(b).1x(a.1w(12(a,b){14 c=11.1u(b)[0];c&&c.35()},11))},4S:12(){a.1x(11.3J(),12(a,b){b.1K()})},2Q:12(b){1g(d.2l(b)){14 c=b,e=11.1u(c)[0];e&&e.2Q()}1I a(b).1x(a.1w(12(a,b){14 c=11.1u(b)[0];c&&c.2Q()},11))},3J:12(){14 b=[];1b a.1x(11.2C,12(a,c){c.1N()&&b.2o(c)}),b},5T:12(b){14 c=!1;1b d.2l(b)&&a.1x(11.3J()||[],12(a,d){1b d.1h==b?(c=!0,!1):3u 0}),c},7F:12(){14 c,b=0;1b a.1x(11.2C,12(a,d){d.2m>b&&(b=d.2m,c=d)}),c},7G:12(){1>=11.3J().1Z&&a.1x(11.2C,12(b,c){c.1H("1R")&&!c.1a.2m&&a(c.1l).1p({2m:c.2m=+B.1a.4D})})},32:12(a){11.2C[a.1W]=a},5j:12(b){14 c=11.5i(b);1g(c){14 d=a(c.1h).1Y("2q-1W");3H 11.2C[d],c.1K(),c.1A()}},1A:12(b){d.2l(b)?11.5j(b):a(b).1x(a.1w(12(a,b){11.5j(b)},11))},71:12(){a.1x(11.2C,a.1w(12(a,b){b.1h&&!d.1h.5I(b.1h)&&11.5j(b.1h)},11))},5R:12(a){11.1a.3X=a||"6h"},5S:12(a){11.1a.4D=a||0},5V:12(){a.1x(11.2C,a.1w(12(a,b){b.1q&&b.1q.2n&&(b.1q.2n.6k(),b.1q.2n=1s),b.2a("3d",!1)},11)),i.6V()},6D:12(){12 f(d){14 e;1b e="2t"==a.1r(d)?{1h:c.27&&c.27.1h||b.27.1h,2w:d}:A(a.1m({},b.27),d)}12 g(f){1b b=1U.2E.7H,c=A(a.1m({},b),1U.2E.6l),d=1U.2E.6m.7H,e=A(a.1m({},d),1U.2E.6m.6l),g=h,h(f)}12 h(g){g.23=g.23&&1U.2E[g.23]?g.23:1U.2E[B.1a.3X]?B.1a.3X:"6h";14 h=g.23?a.1m({},1U.2E[g.23]||1U.2E[B.1a.3X]):{},i=A(a.1m({},c),h),j=A(a.1m({},i),g);1g(j.2f){14 k=c.2f||{},l=b.2f;"4v"==a.1r(j.2f)&&(j.2f={3Y:k.3Y||l.3Y,1r:k.1r||l.1r}),j.2f=A(a.1m({},l),j.2f)}1g(j.1k&&"2t"==a.1r(j.1k)&&(j.1k={1E:j.1k,1M:1}),j.1j){14 m,n=c.1j||{},o=b.1j;m="2A"==a.1r(j.1j)?{2v:j.1j,1E:n.1E||o.1E,1M:n.1M||o.1M}:A(a.1m({},o),j.1j),j.1j=0===m.2v?!1:m}1g(j.1o){14 p;p="2A"==a.1r(j.1o)?{2v:j.1o,1e:c.1o&&c.1o.1e||b.1o.1e}:A(a.1m({},b.1o),j.1o),j.1o=0===p.2v?!1:p}14 q,s=s=j.1v&&j.1v.1D||"2t"==a.1r(j.1v)&&j.1v||c.1v&&c.1v.1D||"2t"==a.1r(c.1v)&&c.1v||b.1v&&b.1v.1D||b.1v,t=j.1v&&j.1v.1F||c.1v&&c.1v.1F||b.1v&&b.1v.1F||B.2s.6n(s);1g(j.1v?"2t"==a.1r(j.1v)?q={1D:j.1v,1F:B.2s.7I(j.1v)}:(q={1F:t,1D:s},j.1v.1F&&(q.1F=j.1v.1F),j.1v.1D&&(q.1D=j.1v.1D)):q={1F:t,1D:s},"2O"==j.1D){14 u=r.2K(q.1D);q.1D="1L"==u?q.1D.63(/(17|1Q)/,"2u"):q.1D.63(/(18|1S)/,"2u")}j.1v=q;14 v;1g("2O"==j.1D?(v=a.1m({},b.1B),a.1m(v,1U.2E.6l.1B||{}),g.23&&a.1m(v,(1U.2E[g.23]||1U.2E[B.1a.3X]).1B||{}),v=B.2s.7J(b.1B,b.1v,q.1D,!0),g.1B&&(v=a.1m(v,g.1B||{})),j.3Z=0):v={x:j.1B.x,y:j.1B.y},j.1B=v,j.1z&&j.7K){14 w=a.1m({},1U.2E.6m[j.7K]),x=A(a.1m({},e),w);1g(x.2r&&a.1x(["6d","6e"],12(b,c){14 f=x.2r[c],g=e.2r&&e.2r[c];1g(f.1k){14 h=g&&g.1k;1g("2A"==a.1r(f.1k))f.1k={1E:h&&h.1E||d.2r[c].1k.1E,1M:f.1k};1I 1g("2t"==a.1r(f.1k)){14 i=h&&"2A"==a.1r(h.1M)&&h.1M||d.2r[c].1k.1M;f.1k={1E:f.1k,1M:i}}1I f.1k=A(a.1m({},d.2r[c].1k),f.1k)}1g(f.1j){14 j=g&&g.1j;f.1j="2A"==a.1r(f.1j)?{1E:j&&j.1E||d.2r[c].1j.1E,1M:f.1j}:A(a.1m({},d.2r[c].1j),f.1j)}}),x.1t){14 z=e.1t&&e.1t.3E&&e.1t.3E==5y?e.1t:d.1t;x.1t.3E&&x.1t.3E==5y&&(z=A(z,x.1t)),x.1t=z}j.1z=x}1g(j.1t){14 C;C="4v"==a.1r(j.1t)?c.1t&&"4v"==a.1r(c.1t)?b.1t:c.1t?c.1t:b.1t:A(a.1m({},b.1t),j.1t||{}),"2A"==a.1r(C.1B)&&(C.1B={x:C.1B,y:C.1B}),j.1t=C}1g(j.1n){14 D={};D="4v"==a.1r(j.1n)?A({},b.1n):A(A({},b.1n),a.1m({},j.1n)),"2A"==a.1r(D.1B)&&(D.1B={x:D.1B,y:D.1B}),j.1n=D}1g(j.30&&("2t"==a.1r(j.30)?j.30={5k:j.30,7L:!0}:"4v"==a.1r(j.30)&&(j.30=j.30?{5k:"4U",7L:!0}:!1)),j.27&&"2D-9x"==j.27&&(j.7M=!0,j.27=!1),j.27)1g(a.5Y(j.27)){14 E=[];a.1x(j.27,12(a,b){E.2o(f(b))}),j.27=E}1I j.27=[f(j.27)];1b j.2M&&"2t"==a.1r(j.2M)&&(j.2M=[""+j.2M]),j.2e=0,j.1O&&(1P.6o||(j.1O=!1)),j}14 b,c,d,e;1b g}()};B.2s=12(){12 c(c){14 d=r.2P(c),e=d[1],f=d[2],g=r.2K(c),h=a.1m({1L:!0,2c:!0},22[1]||{});1b"1L"==g?(h.2c&&(e=b[e]),h.1L&&(f=b[f])):(h.2c&&(f=b[f]),h.1L&&(e=b[e])),e+f}12 f(a){14 d=r.2P(a);1b c(d[1]+b[d[2]])}12 h(b,c){a(b.1l).1p({18:c.18+"2x",17:c.17+"2x"})}12 j(a,b,d,e){14 g=y(a,b,d,e),h=d&&"2t"==7N d.1r?d.1r:"";1g(/9y$/.3i(h),1===g.40.41)1b l(a,g),g;14 m=b,n=e,o={1L:!g.40.1L,2c:!g.40.2c},p={1L:!1,2c:!1},q=r.2K(b);1b((p.2c="1L"==q&&o.2c)||(p.1L="2c"==q&&o.1L))&&(m=c(b,p),n=c(e,p),g=y(a,m,d,n),1===g.40.41)?(l(a,g),g):(g=k(g,a),l(a,g),g)}12 k(a,b){14 c=z(b),d=c.1c,e=c.1e,f=u.1u(b.1h).1q.1v[a.1v.1F].1F.1c,g=a.1e,h={18:0,17:0,3B:[]};1b e.17>g.17&&(h.17=e.17-g.17,h.3B.2o("17"),a.1e.17=e.17),e.18>g.18&&(h.18=g.18-e.18,h.3B.2o("18"),a.1e.18=e.18),e.17+d.15<g.17+f.15&&(h.17=e.17+d.15-(g.17+f.15),h.3B.2o("1Q"),a.1e.17=e.17+d.15-f.15),e.18+d.19<g.18+f.19&&(h.18=e.18+d.19-(g.18+f.19),h.3B.2o("1S"),a.1e.18=e.18+d.19-f.19),a.7O=h,a}12 l(a,b){a.5f(b.1v.1F,b.40.4n,b.7O),h(a,b.1e)}12 m(a){1b a&&(/^2O|2D|3I$/.3i("2t"==7N a.1r&&a.1r||"")||a.5H>=0)}12 n(a,b,c){1b a>=b&&c>=a}12 o(a,b,c,d){14 e=n(a,c,d),f=n(b,c,d);1g(e&&f)1b b-a;1g(e&&!f)1b d-a;1g(!e&&f)1b b-c;14 g=n(c,a,b),h=n(d,a,b);1b g&&h?d-c:g&&!h?b-c:!g&&h?d-a:0}12 q(a,b){1b o(a.1e.17,a.1e.17+a.1c.15,b.1e.17,b.1e.17+b.1c.15)*o(a.1e.18,a.1e.18+a.1c.19,b.1e.18,b.1e.18+b.1c.19)}12 s(a,b){14 c=a.1c.15*a.1c.19;1b c?q(a,b)/c:0}12 t(a,b){14 c=r.2P(b),d=r.2K(b),e={17:0,18:0};1g("1L"==d){1V(c[2]){1i"2u":1i"2T":e.17=.5*a.15;1C;1i"1Q":e.17=a.15}"1S"==c[1]&&(e.18=a.19)}1I{1V(c[2]){1i"2u":1i"2T":e.18=.5*a.19;1C;1i"1S":e.18=a.19}"1Q"==c[1]&&(e.17=a.15)}1b e}12 v(b){14 c=d.1h.4M(b),e=d.1h.4I(b),f={18:a(1P).4J(),17:a(1P).4K()};1b c.17+=-1*(e.17-f.17),c.18+=-1*(e.18-f.18),c}12 y(b,e,f,g){14 h,i,j,k=u.1u(b.1h),l=k.1a,n=l.1B,o=m(f);1g(o||!f){1g(j={15:24,19:24},o){14 p=d.5G(f);h={18:p.y-.5*j.19+6,17:p.x-.5*j.15+6}}1I{14 q=b.1q.2w;h={18:(q?q.y:0)-.5*j.19+6,17:(q?q.x:0)-.5*j.15+6}}b.1q.2w={x:h.17,y:h.18}}1I h=v(f),j={15:a(f).7P(),19:a(f).7Q()};1g(l.1n&&"2O"!=l.1D){14 y=r.2P(g),A=r.2P(e),C=r.2K(g),D=k.1q.1a,E=k.4r().1j.1c,F=D.1o,G=D.1j,H=F&&"1k"==l.1o.1e?F:0,I=F&&"1j"==l.1o.1e?F:F+G,J=G+H+.5*l.1n.15-.5*E.15,K=I>J?I-J:0;4w=1d.1G(G+H+.5*l.1n.15+K+l.1n.1B["1L"==C?"x":"y"]),"1L"==C&&"17"==y[2]&&"17"==A[2]||"1Q"==y[2]&&"1Q"==A[2]?(j.15-=2*4w,h.17+=4w):("2c"==C&&"18"==y[2]&&"18"==A[2]||"1S"==y[2]&&"1S"==A[2])&&(j.19-=2*4w,h.18+=4w)}i=a.1m({},h);14 L=o?c(l.1v.1F):l.1v.1D,M=t(j,L),N=t(j,g);({18:h.18+M.18+n.y,17:h.17+M.17+n.x}),h={17:h.17+N.17,18:h.18+N.18};14 P=a.1m({},n);P=x(P,L,g,"2O"==k.1a.1D),h.18+=P.y,h.17+=P.x;14 k=u.1u(b.1h),Q=k.1q.1v,R=a.1m({},Q[e]),S={x:0,y:0},y=r.2P(g);1g("2u"!=y[2]){14 C=C=r.2K(g),T=B.2s.6n(g,"2c"==C?{1L:!0,2c:!1}:{1L:!1,2c:!0});e==T&&(S.y=k.3C.5d.y,S.x=k.3C.5d.x)}14 U={18:h.18-R.2L.18-S.y,17:h.17-R.2L.17-S.x};R.1F.1e=U;14 V={1L:!0,2c:!0},W={x:0,y:0};1g(b.1a.30){14 X=z(b),Y=b.1a.1t?w.1u(b.1h):k,Z=Y.2p().1F.1c;V.41=s({1c:Z,1e:U},X),1>V.41&&((U.17<X.1e.17||U.17+Z.15>X.1e.17+X.1c.15)&&(V.1L=!1,W.x=U.17<X.1e.17?U.17-X.1e.17:U.17+Z.15-(X.1e.17+X.1c.15)),(U.18<X.1e.18||U.18+Z.19>X.1e.18+X.1c.19)&&(V.2c=!1,W.y=U.18<X.1e.18?U.18-X.1e.18:U.18+Z.19-(X.1e.18+X.1c.19)))}1I V.41=1;V.4n=W;14 $=Q[e].1J,7R=s({1c:j,1e:i},{1c:$.1c,1e:{18:U.18+$.1e.18,17:U.17+$.1e.17}});1b{1e:U,41:{1D:7R},40:V,1v:{1F:e,1D:g}}}12 z(b){14 c={18:a(1P).4J(),17:a(1P).4K()},e=b.1a,f=e.1D;("2O"==f||"4G"==f)&&(f=b.1h);14 g=a(f).5g(e.30.5k).7m()[0];1g(!g||"4U"==e.30.5k)1b{1c:p.4U(),1e:c};14 h=d.1h.4M(g),i=d.1h.4I(g);1b h.17+=-1*(i.17-c.17),h.18+=-1*(i.18-c.18),{1c:{15:a(g).5W(),19:a(g).5X()},1e:h}}14 b={17:"1Q",1Q:"17",18:"1S",1S:"18",2u:"2u",2T:"2T"};e.3n&&9>e.3n||e.4N&&2>e.4N||e.5N&&9z>e.5N;14 x=12(){14 a=[[-1,-1],[0,-1],[1,-1],[-1,0],[0,0],[1,0],[-1,1],[0,1],[1,1]],b={3S:0,3P:0,4d:1,59:1,3Q:2,3R:2,4e:5,5a:5,4f:8,4g:8,4h:7,5b:7,4i:6,4j:6,4k:3,5c:3};1b 12(c,d,e,f){14 g=a[b[d]],h=a[b[e]],i=[1d.67(.5*1d.2W(g[0]-h[0]))?-1:1,1d.67(.5*1d.2W(g[1]-h[1]))?-1:1];1b r.37(d)||!r.37(e)||f||("1L"==r.2K(e)?i[0]=0:i[1]=0),{x:i[0]*c.x,y:i[1]*c.y}}}();1b{1u:y,4Q:j,6n:c,7I:f,7S:v,7J:x,6p:m}}(),B.2s.4T={x:0,y:0},a(1y).6Z(12(){14 b=B.2s;a(1y).3V("5l",12(a){b.4T={x:a.5H,y:a.6K}})}),B.54=12(){12 b(){a(1y.3e).21(a(1y.25("2j")).20("9A").21(a(1y.25("2j")).20("3D").21(a(11.1l=1y.25("2j")).20("7T"))))}12 c(b){1b{15:a(b).5W(),19:a(b).5X()}}12 e(b){14 d=c(b),e=b.4L;1b e&&a(e).1p({15:d.15+"2x"})&&c(b).19>d.19&&d.15++,a(e).1p({15:"64%"}),d}12 f(b,c,e){11.1l||11.1R();14 f=b.1a,g=a.1m({1O:!1},22[3]||{});!f.7U&&!d.2l(c)||a(c).1Y("7V")||(f.7U&&"2t"==a.1r(c)&&(b.3a=a("#"+c)[0],c=b.3a),!b.42&&c&&d.1h.5I(c)&&(a(b.3a).1Y("7W",a(b.3a).1p("7X")),b.42=1y.25("2j"),a(b.3a).6g(a(b.42).1K())));14 h=1y.25("2j");a(11.1l).21(a(h).20("7l 9B").21(c)),d.2l(c)&&a(c).1X(),f.23&&a(h).20("9C"+b.1a.23);14 i=a(h).69("7Y[4o]").9D(12(){1b!(a(11).3h("19")&&a(11).3h("15"))});1g(i.1Z>0&&!b.1H("3F")){b.2a("3F",!0),f.1O&&(g.1O||b.1O||(b.1O=b.6q(f.1O)),b.1H("1N")&&(b.1e(),a(b.1l).1X()),b.1O.6r());14 j=0,k=1d.1T(9E,9F*(i.1Z||0));b.2k("3F"),b.43("3F",a.1w(12(){i.1x(12(){11.6s=12(){}}),j>=i.1Z||(11.5m(b,h),e&&e())},11),k),a.1x(i,a.1w(12(c,d){14 f=3r 9G;f.6s=a.1w(12(){f.6s=12(){};14 c=f.15,g=f.19,k=a(d).3h("15"),l=a(d).3h("19");k&&l||(!k&&l?(c=1d.26(l*c/g),g=l):!l&&k&&(g=1d.26(k*g/c),c=k),a(d).3h({15:c,19:g}),j++),j==i.1Z&&(b.2k("3F"),b.1O&&(b.1O.1A(),b.1O=1s),b.1H("1N")&&a(b.1l).1K(),11.5m(b,h),e&&e())},11),f.4o=d.4o},11))}1I 11.5m(b,h),e&&e()}12 g(b,c){14 d=e(c),f={15:d.15-(2z(a(c).1p("2e-17"))||0)-(2z(a(c).1p("2e-1Q"))||0),19:d.19-(2z(a(c).1p("2e-18"))||0)-(2z(a(c).1p("2e-1S"))||0)};b.1a.3j&&"2A"==a.1r(b.1a.3j)&&f.15>b.1a.3j&&(a(c).1p({15:b.1a.3j+"2x"}),d=e(c)),b.1q.2I=d,a(b.2Y).7Z(c)}1b e=d.6I(e,12(a,b){14 c=a(b);1b c.19+=13,c}),{1R:b,44:f,5m:g,6b:e}}(),a.1m(C.3G,12(){12 b(a,b,c){11.1q.3c[a]=d.4H(b,c)}12 c(a){1b 11.1q.3c[a]}12 e(a){11.1q.3c[a]&&(1P.6j(11.1q.3c[a]),3H 11.1q.3c[a])}12 f(){a.1x(11.1q.3c,12(a,b){1P.6j(b)}),11.1q.3c=[]}12 g(b,c,d,e){c=c;14 f=a.1w(d,e||11);11.1q.5B.2o({1h:b,80:c,81:f}),a(b).3V(c,f)}12 h(){a.1x(11.1q.5B,12(b,c){a(c.1h).82(c.80,c.81)})}12 j(a,b){11.1q.2r[a]=b}12 l(a){1b 11.1q.2r[a]}12 m(){11.2F(11.1h,"4q",11.5n),11.2F(11.1h,"56",a.1w(12(a){11.6t(a)},11)),11.1a.2M&&a.1x(11.1a.2M,a.1w(12(b,c){14 d=!1;"2D"==c&&(11.1a.27&&a.1x(11.1a.27,12(a,b){1b"4G"==b.1h&&"2D"==b.2w?(d=!0,!1):3u 0}),11.2a("5C",d)),11.2F(11.1h,c,"2D"==c?d?11.35:11.1X:a.1w(12(){11.83()},11))},11)),11.1a.27?a.1x(11.1a.27,a.1w(12(b,c){14 d;1V(c.1h){1i"4G":1g(11.1H("5C")&&"2D"==c.2w)1b;d=11.1h;1C;1i"1D":d=11.1D}d&&11.2F(d,c.2w,"2D"==c.2w?11.1K:a.1w(12(){11.6u()},11))},11)):11.1a.84&&11.1a.2M&&!a.6v("2D",11.1a.2M)>-1&&11.2F(11.1h,"56",a.1w(12(){11.2k("1X")},11));14 b=!1;!11.1a.9H&&11.1a.2M&&((b=a.6v("5l",11.1a.2M)>-1)||a.6v("5o",11.1a.2M)>-1)&&"2O"==11.1D&&11.2F(11.1h,b?"5l":"5o",12(a){11.1H("4F")&&11.1e(a)})}12 n(){11.2F(11.1l,1U.2J.3I?"5o":"4q",11.5n),11.2F(11.1l,"56",11.6t),11.2F(11.1l,1U.2J.3I?"5o":"4q",a.1w(12(){11.5p("4x")||11.1X()},11)),11.1a.27&&a.1x(11.1a.27,a.1w(12(b,c){14 d;1V(c.1h){1i"1F":d=11.1l}d&&11.2F(d,c.2w,c.2w.3f(/^(2D|5l|4q)$/)?11.1K:a.1w(12(){11.6u()},11))},11))}12 o(a,b,c){14 d=u.1u(11.1h);d&&d.5f(a,b,c)}12 p(a){14 b=u.1u(11.1h);b&&b.4p(a)}12 q(){11.4p(11.1a.1v.1F)}12 r(){a(11.1l=1y.25("2j")).20("3D"),11.85()}12 s(){11.1R();14 a=u.1u(11.1h);a?a.1R():(3r v(11.1h),11.2a("4F",!0))}12 t(){11.1H("1R")||(a(1y.3e).21(a(11.1l).1p({17:"-5q",18:"-5q",2m:11.2m}).21(a(11.51=1y.25("2j")).20("9I")).21(a(11.2Y=1y.25("2j")).20("7T"))),a(11.1l).20("9J"+11.1a.23),11.1a.7M&&(a(11.1h).20("86"),11.2F(1y.7C,"2D",a.1w(12(b){1g(11.1N()){14 c=a(b.1D).5g(".3D, .86")[0];(!c||c&&c!=11.1l&&c!=11.1h)&&11.1K()}},11))),1U.2J.4a&&(11.1a.4y||11.1a.3Z)&&(11.5r(11.1a.4y),a(11.1l).20("6w")),11.87(),11.2a("1R",!0),B.32(11))}12 w(){14 c;11.2H,11.42&&11.3a&&((c=a(11.3a).1Y("7W"))&&a(11.3a).1p({7X:c}),a(11.42).6g(11.3a).1A(),11.42=1s)}12 x(){d.47(a.1w(12(){11.88()},11)),11.89(),11.6x(),d.47(a.1w(12(){a(11.1l).69("7Y[4o]").82("9K")},11)),u.1A(11.1h),11.1H("1R")&&11.1l&&(a(11.1l).1A(),11.1l=1s);14 c,b="5A";(c=a(11.1h).1Y(b))&&a(11.1h).3h("5z",c).8a("5A"),a(11.1h).8a("2q-1W")}12 y(b){14 c=a.1m({4z:11.1a.4z,1O:!1},22[1]||{});11.1R(),11.1H("1N")&&a(11.1l).1K(),B.54.44(11,b,a.1w(12(){14 b=11.1H("1N");b||11.2a("1N",!0),11.8b(),b||11.2a("1N",!1),11.1H("1N")&&(a(11.1l).1K(),11.1e(),11.5s(),a(11.1l).1X()),11.2a("3d",!0),c.4z&&c.4z(11.2Y.3W,11.1h),c.4A&&c.4A()},11),{1O:c.1O})}12 z(b){14 c,d={49:11.2H,1r:11.1a.2f.1r,1Y:11.1a.2f.1Y||{},8c:11.1a.2f.8c||"7Z"};1g(!(11.1H("2n")||11.1a.2f.3Y&&11.1H("3d"))){1g(11.1a.2f.3Y&&(c=i.1u(d)))1b 11.6y(c,{4A:a.1w(12(){11.1H("1N")&&11.1a.46&&11.1a.46(11.2Y.3W,11.1h)},11)}),3u 0;11.2a("2n",!0),11.1a.1O&&(11.1O?11.1O.6r():(11.1O=11.6q(11.1a.1O),11.2a("3d",!1)),11.1e(b)),11.1q.2n&&(11.1q.2n.6k(),11.1q.2n=1s),11.1q.2n=a.2f(a.1m({},d,{9L:a.1w(12(b,c,e){0!==e.9M&&(i.4Q(d,e.4P),11.6y(e.4P,{4A:a.1w(12(){11.2a("2n",!1),11.1H("1N")&&11.1a.46&&11.1a.46(11.2Y.3W,11.1h),11.1O&&(11.1O.1A(),11.1O=1s)},11)}))},11)}))}}12 A(b){14 c=a.1m({1O:11.1a.1O&&11.1O},22[1]||{});11.44(b,c)}12 C(){14 b=1y.25("2j");a(b).1Y("7V",!0);14 c=6o.4R(b,a.1m({},22[0]||{})),d=6o.60(b);1b a(b).1p(k(d)),11.44(b,{4z:!1,4A:12(){c.6r()}}),c}12 E(){1g(11.1H("1R")&&!11.1a.2m){14 b=B.7F();b&&b!=11&&11.2m<=b.2m&&a(11.1l).1p({2m:11.2m=b.2m+1})}}12 F(){14 a=u.1u(11.1h);a&&(a.2Q(),11.1N()&&11.1e())}12 G(a){1g(1U.2J.4a){a=a||0;14 b=11.1l.9N;b.9O=a+"5t",b.9P=a+"5t",b.9Q=a+"5t",b.9R=a+"5t"}}12 H(b){11.2k("1K"),11.2k("4x"),11.1H("1N")||11.5p("1X")||11.43("1X",a.1w(12(){11.2k("1X"),11.1X(b)},11),11.1a.84||1)}12 I(b){1g(11.2k("1K"),11.2k("4x"),!11.1N()){1g("12"==a.1r(11.2H)||"12"==a.1r(11.1q.5u)){"12"!=a.1r(11.1q.5u)&&(11.1q.5u=11.2H);14 c=11.1q.5u(11.1h)||!1;1g(c!=11.1q.5D&&(11.1q.5D=c,11.2a("3d",!1),11.6x()),11.2H=c,!c)1b}11.1a.9S&&B.4S(),11.2a("1N",!0),11.1a.2f?11.8d(b):11.1H("3d")||11.44(11.2H),11.1H("4F")&&11.1e(b),11.5s(),11.1a.5v&&d.47(a.1w(12(){11.5n()},11)),"12"==a.1r(11.1a.46)&&(!11.1a.2f||11.1a.2f&&11.1a.2f.3Y&&11.1H("3d"))&&11.1a.46(11.2Y.3W,11.1h),1U.2J.4a&&(11.1a.4y||11.1a.3Z)&&(11.5r(11.1a.4y),a(11.1l).20("8e").8f("6w")),a(11.1l).1X()}}12 J(){11.2k("1X"),11.1H("1N")&&(11.2a("1N",!1),1U.2J.4a&&(11.1a.4y||11.1a.3Z)?(11.5r(11.1a.3Z),a(11.1l).8f("8e").20("6w"),11.43("4x",a.1w(11.6z,11),11.1a.3Z)):11.6z(),11.1q.2n&&(11.1q.2n.6k(),11.1q.2n=1s,11.2a("2n",!1)))}12 K(){11.1H("1R")&&(a(11.1l).1p({17:"-5q",18:"-5q"}),B.7G(),"12"!=a.1r(11.1a.8g)||11.1O||11.1a.8g(11.2Y.3W,11.1h))}12 L(){11.2k("1X"),!11.5p("1K")&&11.1H("1N")&&11.43("1K",a.1w(12(){11.2k("1K"),11.2k("4x"),11.1K()},11),11.1a.9T||1)}12 M(a){11[11.1N()?"1K":"1X"](a)}12 N(){1b 11.1H("1N")}12 O(){11.2a("4E",!0),11.1H("1N")&&11.5s(),11.1a.5v&&11.2k("6A")}12 P(){11.2a("4E",!1),11.1a.5v&&11.43("6A",a.1w(12(){11.2k("6A"),11.1H("4E")||11.1K()},11),11.1a.5v)}14 D=12(b){1g(11.1N()){14 c;1g("2O"==11.1a.1D){14 e=B.2s.6p(b),f=B.2s.4T;1g(e)f.x||f.y?(11.1q.2w={x:f.x,y:f.y},c=1s):c=b;1I{1g(f.x||f.y)11.1q.2w={x:f.x,y:f.y};1I 1g(!11.1q.2w){14 g=B.2s.7S(11.1h);11.1q.2w={x:g.17,y:g.18}}c=1s}}1I c=11.1D;1g(B.2s.4Q(11,11.1a.1v.1F,c,11.1a.1v.1D),b&&B.2s.6p(b)){14 h={15:a(11.1l).7P(),19:a(11.1l).7Q()},i=d.5G(b),g=d.1h.4M(11.1l);i.x>=g.17&&i.x<=g.17+h.15&&i.y>=g.18&&i.y<=g.18+h.19&&d.47(a.1w(12(){11.2k("1K")},11))}}};1b{1R:t,6G:r,8b:s,85:m,87:n,1X:I,1K:J,6z:K,35:M,1N:N,83:H,6u:L,5r:G,2a:j,1H:l,5n:O,6t:P,5p:c,43:b,2k:e,89:f,2F:g,88:h,5f:o,4p:p,9U:q,2Q:F,44:y,8d:z,6y:A,6q:C,1e:D,5s:E,6x:w,1A:x}}()),1U.3q()})(48);',62,615,'|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||this|function||var|width||left|top|height|options|return|dimensions|Math|position|lineTo|if|element|case|border|background|container|extend|stem|radius|css|_cache|type|null|shadow|get|hook|proxy|each|document|closeButton|remove|offset|break|target|color|tooltip|ceil|getState|else|bubble|hide|horizontal|opacity|visible|spinner|window|right|build|bottom|max|Tipped|switch|uid|show|data|length|addClass|append|arguments|skin||createElement|round|hideOn|for|arc|setState|_hookPosition|vertical||padding|ajax|getTooltip|beginPath|closePath|div|clearTimer|isElement|zIndex|xhr|push|getOrderLayout|tipped|states|Position|string|middle|size|event|px|_globalAlpha|parseInt|number|box|tooltips|click|Skins|setEvent|180|content|contentDimensions|support|getOrientation|anchor|showOn|globalAlpha|mouse|split|refresh|fillStyle|hex2fill|center|iframeShim|closeButtonShadow|abs|bubbleCanvas|contentElement|blurs|containment|PI|add|blur|scripts|toggle|fill|isCenter|cleanup|cornerOffset|inlineContent|_stemCorrection|timers|updated|body|match|canvas|attr|test|maxWidth|shadows|getSkin|_adjustment|IE|indexOf|getContext|init|new|devicePixelRatio|moveTo|void|charAt|toLowerCase|diameter|hookPosition|layout|stemLayout|sides|_corrections|t_Tooltip|constructor|preloading_images|prototype|delete|touch|getVisible|resize|x1|y1|x2|y2|topleft|topright|righttop|lefttop|math|getLayout|bind|firstChild|defaultSkin|cache|fadeOut|contained|overlap|inlineMarker|setTimer|update||onShow|defer|jQuery|url|cssTransitions|items|createFillStyle|topmiddle|rightmiddle|rightbottom|bottomright|bottommiddle|bottomleft|leftbottom|leftmiddle|regex|getBorderDimensions|correction|src|setHookPosition|mouseenter|getStemLayout|transition|Stem|closeButtonCanvas|boolean|sideOffset|fadeTransition|fadeIn|afterUpdate|callback|cos|000|startingZIndex|active|skinned|self|delay|cumulativeScrollOffset|scrollTop|scrollLeft|parentNode|cumulativeOffset|Gecko|Chrome|responseText|set|create|hideAll|mouseBuffer|viewport|min|G_vmlCanvasManager|getCenterBorderDimensions|substring|skins||skinElement|prepare|order|UpdateQueue||mouseleave|rotate|borderRadius|topcenter|rightcenter|bottomcenter|leftcenter|corner|corrections|setHookPositionAndStemCorrection|closest|_resizeTimer|_getTooltip|_remove|selector|mousemove|_updateTooltip|setActive|touchmove|getTimer|10000px|setFadeDuration|raise|ms|contentFunction|hideAfter|console|in|Object|title|tipped_restore_title|events|toggles|fnCallContent|call|apply|pointer|pageX|isAttached|RegExp|parseFloat|Opera|opera|WebKit|required|available|findElement|setDefaultSkin|setStartingZIndex|isVisibleByElement|undefined|clearAjaxCache|innerWidth|innerHeight|isArray|getSide|getDimensions|getBubbleLayout|nullifyCornerOffset|replace|100|defaultCloseButton|hoverCloseButton|floor|prepend|find|auto|getMeasureElementDimensions|drawCloseButtonState|default|hover|_drawBackgroundPath|before|dark|getByTooltipElement|clearTimeout|abort|reset|CloseButtons|getInversedPosition|Spinners|isPointerEvent|insertSpinner|play|onload|setIdle|hideDelayed|inArray|t_hidden|_restoreInlineContent|afterAjaxUpdate|_hide|idle|warn|_stemPosition|createOptions|getAttribute|getElementById|_preBuild|Array|wrap|concat|pageY|version|AppleWebKit|MobileSafari|check|pow|Za|checked|notified|toUpperCase|param|clear|try|DocumentTouch|catch|ready|startDelegating|removeDetached|drawRoundedRectangle|fillRect|drawPixelArray|Gradient|addColorStops|positions|toOrientation|side|toDimension|isCorner|atan|red|green|blue|360|getSaturatedBW|drawBubble|drawCloseButton|createHookCache|t_ContentContainer|first|25000px|setStemCorrection|setAdjustment|t_Close|closeButtonShift|closeButtonMouseover|closeButtonMouseout|CloseButton|stemOffset|backgroundRadius|60060600006060606006|_drawBorderPath|setGlobalAlpha|drawBackground|getBlurOpacity|documentElement|onWindowResize|is|getHighestTooltip|resetZ|base|getTooltipPositionFromTarget|adjustOffsetBasedOnHooks|closeButtonSkin|flip|hideOnClickOutside|typeof|adjustment|outerWidth|outerHeight|_|getAbsoluteOffset|t_Content|inline|isSpinner|tipped_restore_inline_display|display|img|html|eventName|handler|unbind|showDelayed|showDelay|createPreBuildObservers|t_hideOnClickOutside|createPostBuildObservers|clearEvents|clearTimers|removeData|_buildSkin|dataType|ajaxUpdate|t_visible|removeClass|onHide|log|sqrt|object|setAttribute|slice|nodeType|setTimeout|do|while|exec|attachEvent|MSIE|KHTML|rv|Apple|Mobile|Safari|navigator|userAgent|fn|jquery|z_|z0|requires|_t_uid_|ontouchstart|instanceof|WebKitTransitionEvent|TransitionEvent|OTransitionEvent|createEvent|scale|initElement|createLinearGradient|addColorStop|spacing|rgba|join|fff|255|hue|saturation|brightness|0123456789abcdef|hex2rgb||init_|t_Bubble|iframe|t_iframeShim|frameBorder|javascript|15000px|t_CloseButtonShift|lineCap|t_CloseState|translate|stemCorrection|270|lineWidth|6660066660666660066|60060666006060606006|6660066660606060066|sin|setOpacity|getCenterBorderDimensions2|acos|t_Shadow|t_ShadowBubble|t_CloseButtonShadow|999999|touchstart|delegate|close|preventDefault|stopPropagation|200|getBySelector|outside|move|530|t_UpdateQueue|t_clearfix|t_Content_|filter|8e3|750|Image|fixed|t_Skin|t_Tooltip_|load|success|status|style|MozTransitionDuration|webkitTransitionDuration|OTransitionDuration|transitionDuration|hideOthers|hideDelay|resetHookPosition'.split('|'),0,{}));